/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors.jdt;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.core.dom.ASTNode;

public class ASTNodeDocumentRoot {
    private final ASTNode rootNode;
    private final String source;
    private static final Map documentRootsByAST = Collections.synchronizedMap(new WeakHashMap());

    static ASTNodeDocumentRoot documentRootFor(ASTNode astNode) {
        return (ASTNodeDocumentRoot)documentRootsByAST.get(astNode.getAST());
    }

    public ASTNodeDocumentRoot(ASTNode rootNode, String source) {
        this.rootNode = rootNode;
        this.source = source;
        documentRootsByAST.put(rootNode.getAST(), this);
    }

    public ASTNode getRootNode() {
        return this.rootNode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.rootNode == null ? 0 : this.rootNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASTNodeDocumentRoot other = (ASTNodeDocumentRoot)obj;
        return !(this.rootNode == null ? other.rootNode != null : !this.rootNode.equals((Object)other.rootNode));
    }

    public String getName() {
        return "";
    }

    public String stringValue() {
        return this.source != null ? this.source : "";
    }
}

