/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine;

import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicTemplatesEclipseUtil;
import org.eclipse.acceleo.engine.internal.utils.AcceleoEngineRegistry;
import org.eclipse.acceleo.engine.internal.utils.DynamicTemplatesRegistryListener;
import org.eclipse.acceleo.engine.internal.utils.EngineRegistryListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class AcceleoEnginePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.engine";
    private static AcceleoEnginePlugin plugin;
    private final DynamicTemplatesRegistryListener dynamicTemplatesListener = new DynamicTemplatesRegistryListener();
    private final EngineRegistryListener engineCreatorListener = new EngineRegistryListener();

    public static AcceleoEnginePlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, boolean blocker) {
        if (e == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEnginePlugin.LogNullException"));
        }
        if (AcceleoEnginePlugin.getDefault() == null) {
            e.printStackTrace();
        } else if (e instanceof CoreException) {
            AcceleoEnginePlugin.log(((CoreException)e).getStatus());
        } else if (e instanceof NullPointerException) {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoEnginePlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, AcceleoEngineMessages.getString("AcceleoEnginePlugin.ElementNotFound"), (Throwable)e));
        } else {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoEnginePlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, e.getMessage(), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEnginePlugin.LogNullStatus"));
        }
        if (AcceleoEnginePlugin.getDefault() != null) {
            AcceleoEnginePlugin.getDefault().getLog().log(status);
        } else {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public static void log(String message, boolean blocker) {
        if (AcceleoEnginePlugin.getDefault() == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || "".equals(errorMessage)) {
                errorMessage = AcceleoEngineMessages.getString("AcceleoEnginePlugin.UnexpectedException");
            }
            AcceleoEnginePlugin.log((IStatus)new Status(severity, PLUGIN_ID, errorMessage));
        }
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this.dynamicTemplatesListener, "org.eclipse.acceleo.engine.dynamic.templates");
        registry.addListener((IRegistryEventListener)this.engineCreatorListener, "org.eclipse.acceleo.engine.creator");
        this.dynamicTemplatesListener.parseInitialContributions();
        this.engineCreatorListener.parseInitialContributions();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this.dynamicTemplatesListener);
        registry.removeListener((IRegistryEventListener)this.engineCreatorListener);
        AcceleoDynamicTemplatesEclipseUtil.clearRegistry();
        AcceleoEngineRegistry.clearRegistry();
    }
}

