/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.writers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public abstract class AbstractAcceleoWriter
extends Writer {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String DOS_LINE_SEPARATOR = "\r\n";
    protected static final String UNIX_LINE_SEPARATOR = "\n";
    protected static final String MAC_LINE_SEPARATOR = "\r";
    protected Writer delegate = new StringWriter(1024);
    protected StringBuffer currentIndentation;
    protected boolean recordIndentation;

    public void close() throws IOException {
        this.delegate.close();
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public abstract String getTargetPath();

    public String getCurrentLineIndentation() {
        if (this.currentIndentation != null) {
            return this.currentIndentation.toString();
        }
        return "";
    }

    public void reinit() {
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf), off, len);
    }

    public void write(int c) throws IOException {
        this.delegate.write(c);
    }

    public void write(String str, int off, int len) throws IOException {
        int newLineIndex = -1;
        if (str.contains(DOS_LINE_SEPARATOR)) {
            newLineIndex = str.lastIndexOf(DOS_LINE_SEPARATOR) + DOS_LINE_SEPARATOR.length();
        } else if (str.contains(UNIX_LINE_SEPARATOR)) {
            newLineIndex = str.lastIndexOf(UNIX_LINE_SEPARATOR) + UNIX_LINE_SEPARATOR.length();
        } else if (str.contains(MAC_LINE_SEPARATOR)) {
            newLineIndex = str.lastIndexOf(MAC_LINE_SEPARATOR) + MAC_LINE_SEPARATOR.length();
        }
        if (newLineIndex != -1) {
            this.currentIndentation = new StringBuffer();
            this.recordIndentation = true;
        } else if (this.currentIndentation == null) {
            this.currentIndentation = new StringBuffer();
            this.recordIndentation = true;
            newLineIndex = 0;
        } else if (this.recordIndentation) {
            newLineIndex = 0;
        }
        if (this.recordIndentation) {
            int i = newLineIndex;
            while (i < str.length()) {
                if (!Character.isWhitespace(str.charAt(i))) {
                    this.recordIndentation = false;
                    break;
                }
                this.currentIndentation.append(str.charAt(i));
                ++i;
            }
        }
        this.delegate.write(str, off, len);
    }
}

