/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import java.util.LinkedHashMap;
import java.util.Map;

public final class TagInfo {
    private final int line;
    private final Map attrMap;
    private final String tagName;
    private final int col;

    public TagInfo(String tagName, int line, int col, String[] attrNames, String[] attrValues) {
        this.tagName = tagName;
        this.line = line;
        this.col = col;
        if (attrNames == null || attrValues == null) {
            throw new NullPointerException();
        }
        if (attrNames.length != attrValues.length) {
            throw new IllegalArgumentException();
        }
        this.attrMap = new LinkedHashMap(attrNames.length);
        int i = 0;
        while (i < attrNames.length) {
            this.attrMap.put(attrNames[i], attrValues[i]);
            ++i;
        }
    }

    public TagInfo(String tagName, int line, int start, int end, String[] attrNames, String[] attrValues) {
        this(tagName, line, 1, attrNames, attrValues);
    }

    public final int getLine() {
        return this.line;
    }

    public final String getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (String)this.attrMap.get(name);
    }

    public final boolean hasAttribute(String name) {
        return this.attrMap.containsKey(name);
    }

    public String toString() {
        return "[" + this.line + ":" + this.col + " " + this.tagName + " " + this.attrMap + "]";
    }

    public final String getTagName() {
        return this.tagName;
    }

    public final String[] getAttributeNames() {
        return this.attrMap.keySet().toArray(new String[this.attrMap.size()]);
    }

    public final int getCol() {
        return this.col;
    }
}

