/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.transform;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.AbstractContextExtender;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2TemplateLoaderExtension;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.TagFactoryImpl;
import org.eclipse.jet.internal.runtime.model.TransformLoadContext;
import org.eclipse.jet.internal.runtime.model.WorkspaceLoadContext;
import org.eclipse.jet.runtime.model.ILoadContext;
import org.eclipse.jet.runtime.model.IModelLoader;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.transform.IJETBundleManager;
import org.eclipse.jet.transform.TransformContextListener;

public class TransformContextExtender
extends AbstractContextExtender {
    public TransformContextExtender(JET2Context context) {
        super(context);
    }

    private final ContextData getData() {
        return (ContextData)this.getExtendedData();
    }

    protected Object createExtendedData(JET2Context context) {
        context.setTagFactory(new TagFactoryImpl(context));
        return new ContextData();
    }

    public String getId() {
        return this.getData().descriptor.getId();
    }

    public String getTemplatePath() {
        return this.getData().templateStack.isEmpty() ? "" : (String)this.getData().templateStack.peek();
    }

    public void execute(String templatePath, JET2Writer writer) throws JET2TagException {
        this.execute(templatePath, false, writer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String templatePath, boolean useSuper, JET2Writer writer) throws JET2TagException {
        this.getData().templateStack.push(templatePath);
        this.getContext().setTemplatePath(this.getTemplatePath());
        try {
            JET2Template template;
            JET2TemplateLoader templateLoader = this.getData().loader;
            if (useSuper) {
                templateLoader = templateLoader instanceof JET2TemplateLoaderExtension ? ((JET2TemplateLoaderExtension)((Object)templateLoader)).getDelegateLoader() : null;
            }
            JET2Template jET2Template = template = templateLoader != null ? templateLoader.getTemplate(templatePath) : null;
            if (template == null) {
                String msg = JET2Messages.JET2Context_CouldNotFindTemplate;
                throw new JET2TagException(MessageFormat.format(msg, templatePath));
            }
            template.generate(this.getContext(), writer);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getData().templateStack.pop();
            this.getContext().setTemplatePath(this.getTemplatePath());
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.getData().templateStack.pop();
        }
        this.getContext().setTemplatePath(this.getTemplatePath());
    }

    public JET2TemplateLoader getLoader() {
        return this.getData().loader;
    }

    public void setLoader(JET2TemplateLoader loader) {
        if (this.getData().loader != null) {
            throw new IllegalStateException("loader already set");
        }
        this.getData().loader = loader;
    }

    public void addListener(TransformContextListener listener) {
        if (!this.getData().listeners.contains(listener)) {
            this.getData().listeners.add(listener);
        }
    }

    public void removeListener(TransformContextListener listener) {
        this.getData().listeners.remove(listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(IProgressMonitor monitor) {
        monitor.beginTask(JET2Messages.JET2Context_CommittingActions, this.getData().listeners.size());
        try {
            Iterator i = this.getData().listeners.iterator();
            while (i.hasNext()) {
                TransformContextListener listener = (TransformContextListener)i.next();
                try {
                    listener.commit(this.getContext(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (JET2TagException e) {
                    this.getContext().logError(e);
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public final Object getShellContext() {
        return this.getData().shellContext;
    }

    public final void setShellContext(Object shellContext) {
        if (this.getData().shellContext != null) {
            throw new IllegalStateException("shellContext already set");
        }
        this.getData().shellContext = shellContext;
    }

    public void setBundleDescriptor(IJETBundleDescriptor descriptor) {
        if (this.getData().descriptor != null) {
            throw new IllegalStateException();
        }
        this.getData().descriptor = descriptor;
        this.getContext().setJETBundleId(descriptor.getId());
    }

    public IJETBundleDescriptor getBundleDescriptor() {
        return this.getData().descriptor;
    }

    public URL getBaseURL(String urlContext) throws JET2TagException {
        ILoadContext definedContext = null;
        if (urlContext == null || "transform".equalsIgnoreCase(urlContext)) {
            try {
                definedContext = new TransformLoadContext(this.getBundleDescriptor().getBaseURL());
            }
            catch (MalformedURLException e) {
                throw new JET2TagException(e);
            }
        } else if ("workspace".equalsIgnoreCase(urlContext)) {
            definedContext = new WorkspaceLoadContext();
        } else {
            String msg = JET2Messages.LoadTag_UnknownSrcContext;
            throw new JET2TagException(MessageFormat.format(msg, urlContext));
        }
        URL baseURL = definedContext.getContextUrl();
        return baseURL;
    }

    public static TransformContextExtender getInstance(JET2Context context) {
        return new TransformContextExtender(context);
    }

    public static Object loadModel(URL modelURL, String modelLoaderID, String fileType) throws IOException, CoreJETException {
        IModelLoader loader = JETActivatorWrapper.INSTANCE.getLoaderManager().getLoader(modelURL.toExternalForm(), modelLoaderID, fileType);
        Object source = fileType == null ? loader.load(modelURL) : loader.load(modelURL, fileType);
        return source;
    }

    public static Object loadModelFromString(String modelContent, String modelLoaderID, String fileType) throws CoreJETException, IOException {
        IModelLoader loader = JETActivatorWrapper.INSTANCE.getLoaderManager().getLoader(null, modelLoaderID, fileType);
        Object source = loader.loadFromString(modelContent, fileType);
        return source;
    }

    public void setOverride(String id, IProgressMonitor monitor) throws JET2TagException {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        try {
            bundleManager.connect(id, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
            this.getData().connectedTransforms.add(id);
            JET2TemplateLoader delegateLoader = bundleManager.getTemplateLoader(id);
            JET2TemplateLoader loader = this.getLoader();
            if (!(loader instanceof JET2TemplateLoaderExtension)) {
                String msg = JET2Messages.TransformContextExtender_NeedsRebuildForOverride;
                throw new JET2TagException(MessageFormat.format(msg, this.getId()));
            }
            JET2TemplateLoaderExtension ext = (JET2TemplateLoaderExtension)((Object)loader);
            ext.setDelegateLoader(delegateLoader);
        }
        catch (CoreJETException e) {
            throw new JET2TagException(e);
        }
    }

    public void cleanup() {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        Iterator i = this.getData().connectedTransforms.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            bundleManager.disconnect(id);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runSubTransform(String id) throws JET2TagException {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        IJETBundleDescriptor savedDescriptor = this.getData().descriptor;
        JET2TemplateLoader savedLoader = this.getData().loader;
        try {
            try {
                bundleManager.connect(id, (IProgressMonitor)new NullProgressMonitor());
                this.getData().connectedTransforms.add(id);
                JET2TemplateLoader loader = bundleManager.getTemplateLoader(id);
                IJETBundleDescriptor descriptor = bundleManager.getDescriptor(id);
                this.getData().loader = loader;
                this.getData().descriptor = descriptor;
                if (descriptor.getOverridesId() != null) {
                    this.setOverride(descriptor.getOverridesId(), (IProgressMonitor)new NullProgressMonitor());
                }
                this.execute(descriptor.getMainTemplate(), new BodyContentWriter());
            }
            catch (CoreJETException e) {
                throw new JET2TagException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.getData().descriptor = savedDescriptor;
            this.getData().loader = savedLoader;
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        this.getData().descriptor = savedDescriptor;
        this.getData().loader = savedLoader;
    }

    private static final class ContextData {
        private final Stack templateStack = new Stack();
        private JET2TemplateLoader loader;
        private List listeners = new ArrayList();
        private Object shellContext = null;
        private IJETBundleDescriptor descriptor = null;
        private final List connectedTransforms = new ArrayList();

        private ContextData() {
        }
    }
}

