/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.jet.internal.xpath.ast.NodeTestKind;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public abstract class NodeTest {
    private static final NodeTest allNodesTest = new AllNodesTest();
    private static final NodeTest textNodesTest = new SimpleKindNodeTest(NodeTestKind.TEXT);
    private static final NodeTest commentNodesTest = new SimpleKindNodeTest(NodeTestKind.COMMENT);
    private static final NodeTest allPIsNodesTest = new SimpleKindNodeTest(NodeTestKind.PROCESSING_INSTRUCTION);

    private NodeTest() {
    }

    public abstract void filter(Set var1);

    public static NodeTest allNodes() {
        return allNodesTest;
    }

    public static NodeTest textNodes() {
        return textNodesTest;
    }

    public static NodeTest commentNodes() {
        return commentNodesTest;
    }

    public static NodeTest allProcessingInstructionNodes() {
        return allPIsNodesTest;
    }

    public static NodeTest processingInstructionNodes(String piLiteral) {
        return new SpecificPINodeTest(piLiteral);
    }

    public static NodeTest nameTest(INodeInspector.NodeKind principalKind, ExpandedName testName) {
        return new NameTest(principalKind, testName);
    }

    public boolean isSimpleNameTest() {
        return false;
    }

    public ExpandedName getNameTestExpandedName() {
        return null;
    }

    /* synthetic */ NodeTest(NodeTest nodeTest) {
        this();
    }

    private static final class AllNodesTest
    extends NodeTest {
        private AllNodesTest() {
            super(null);
        }

        public void filter(Set nodeSet) {
        }

        public String toString() {
            return "node()";
        }
    }

    public static final class NameTest
    extends SimpleKindNodeTest {
        private final ExpandedName testName;
        private final INodeInspector.NodeKind principalNodeKind;

        public NameTest(INodeInspector.NodeKind principalNodeKind, ExpandedName testName) {
            super(NodeTestKind.PRINCIPAL);
            this.principalNodeKind = principalNodeKind;
            this.testName = testName;
        }

        public void filter(Set nodeSet) {
            InspectorManager inspectorMgr = InspectorManager.getInstance();
            Iterator i = nodeSet.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                INodeInspector inspector = inspectorMgr.getInspector(obj);
                if (inspector != null && inspector.getNodeKind(obj) == this.principalNodeKind && inspector.testExpandedName(obj, this.testName)) continue;
                i.remove();
            }
        }

        public boolean isSimpleNameTest() {
            return !this.testName.hasWildCards();
        }

        public ExpandedName getNameTestExpandedName() {
            return this.testName;
        }

        public String toString() {
            return this.testName.toString();
        }
    }

    private static class SimpleKindNodeTest
    extends NodeTest {
        protected final NodeTestKind testKind;

        public SimpleKindNodeTest(NodeTestKind testKind) {
            super(null);
            if (testKind == null) {
                throw new NullPointerException();
            }
            this.testKind = testKind;
        }

        public void filter(Set nodeSet) {
            InspectorManager inspectorMgr = InspectorManager.getInstance();
            Iterator i = nodeSet.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                INodeInspector inspector = inspectorMgr.getInspector(obj);
                if (this.testKind.test(inspector.getNodeKind(obj))) continue;
                i.remove();
            }
        }

        public String toString() {
            return String.valueOf(this.testKind.toString()) + "()";
        }
    }

    public static final class SpecificPINodeTest
    extends SimpleKindNodeTest {
        private final String piLiteral;

        public SpecificPINodeTest(String piLiteral) {
            super(NodeTestKind.PROCESSING_INSTRUCTION);
            this.piLiteral = piLiteral;
        }

        public void filter(Set nodeSet) {
            super.filter(nodeSet);
            InspectorManager inspectorMgr = InspectorManager.getInstance();
            Iterator i = nodeSet.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                INodeInspector inspector = inspectorMgr.getInspector(obj);
                ExpandedName expandedName = inspector.expandedNameOf(obj);
                if (this.piLiteral.equals(expandedName.getLocalPart())) continue;
                i.remove();
            }
        }

        public String toString() {
            if (this.piLiteral == null) {
                return super.toString();
            }
            return String.valueOf(this.testKind.toString()) + "(" + this.piLiteral + ")";
        }
    }
}

