/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jet.internal.xpath.ast.BooleanExpr;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.internal.xpath.functions.NumberFunction;
import org.eclipse.jet.internal.xpath.functions.StringFunction;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public abstract class RelOp
extends BooleanExpr {
    private static final ITest equalsTest = new ITest(){

        public boolean test(Boolean b, Object o) {
            return b == BooleanFunction.evaluate(o);
        }

        public boolean test(Number n, Object o) {
            return n.doubleValue() == NumberFunction.evaluate(o);
        }

        public boolean test(String s, Object o) {
            return s.equals(StringFunction.evaluate(o));
        }
    };
    private static final ITest notEqualsTest = new ITest(){

        public boolean test(Boolean b, Object o) {
            return !equalsTest.test(b, o);
        }

        public boolean test(Number n, Object o) {
            return !equalsTest.test(n, o);
        }

        public boolean test(String s, Object o) {
            return !equalsTest.test(s, o);
        }
    };
    private static final ITest lessThanTest = new RelativeTest(){

        public boolean test(Number n, Object o) {
            return n.doubleValue() < NumberFunction.evaluate(o);
        }
    };
    private static final ITest lessThanOrEqualTest = new RelativeTest(){

        public boolean test(Number n, Object o) {
            return n.doubleValue() <= NumberFunction.evaluate(o);
        }
    };
    protected final ExprNode left;
    protected final ExprNode right;
    private final ITest test;

    private RelOp(ExprNode left, ExprNode right, ITest test) {
        this.left = left;
        this.right = right;
        this.test = test;
    }

    public final boolean evalAsBoolean(Context context) {
        Object leftVal = this.left.evalAsObject(context);
        Object rightVal = this.right.evalAsObject(context);
        if (leftVal instanceof NodeSet) {
            return this.nodeSetTest((NodeSet)leftVal, rightVal, false);
        }
        if (rightVal instanceof NodeSet) {
            return this.nodeSetTest((NodeSet)rightVal, leftVal, true);
        }
        if (leftVal instanceof Boolean) {
            return this.test.test((Boolean)leftVal, rightVal);
        }
        if (rightVal instanceof Boolean) {
            return this.test.test((Boolean)rightVal, leftVal);
        }
        if (leftVal instanceof Number) {
            return this.test.test((Number)leftVal, rightVal);
        }
        if (rightVal instanceof Number) {
            return this.test.test((Number)rightVal, leftVal);
        }
        String leftString = StringFunction.evaluate(leftVal);
        String rightString = StringFunction.evaluate(rightVal);
        return this.test.test(leftString, (Object)rightString);
    }

    private final boolean nodeSetTest(NodeSet leftNodeSet, Object rightObject, boolean argsReversed) {
        if (rightObject instanceof NodeSet) {
            return this.nodeSetNodeSetTest(leftNodeSet, (NodeSet)rightObject, argsReversed);
        }
        if (rightObject instanceof String) {
            return this.nodeSetStringTest(leftNodeSet, (String)rightObject, argsReversed);
        }
        if (rightObject instanceof Number) {
            return this.nodeSetNumberTest(leftNodeSet, (Number)rightObject, argsReversed);
        }
        if (rightObject instanceof Boolean) {
            return this.nodeSetBooleanTest(leftNodeSet, (Boolean)rightObject, argsReversed);
        }
        return false;
    }

    private final boolean nodeSetNodeSetTest(NodeSet leftNodeSet, NodeSet rightNodeSet, boolean argsReversed) {
        INodeInspector inspector;
        Object contextNode;
        InspectorManager inspectorManager = InspectorManager.getInstance();
        ArrayList<String> leftStrings = new ArrayList<String>(leftNodeSet.size());
        Iterator iter = leftNodeSet.iterator();
        while (iter.hasNext()) {
            contextNode = iter.next();
            inspector = inspectorManager.getInspector(contextNode);
            leftStrings.add(inspector.stringValueOf(contextNode));
        }
        Iterator i = rightNodeSet.iterator();
        while (i.hasNext()) {
            contextNode = i.next();
            inspector = inspectorManager.getInspector(contextNode);
            String rightString = inspector.stringValueOf(contextNode);
            if (!leftStrings.contains(rightString)) continue;
            return true;
        }
        return false;
    }

    private final boolean nodeSetStringTest(NodeSet leftNodeSet, String rightString, boolean argsReversed) {
        InspectorManager inspectorManager = InspectorManager.getInstance();
        Iterator iter = leftNodeSet.iterator();
        while (iter.hasNext()) {
            Object contextNode = iter.next();
            INodeInspector inspector = inspectorManager.getInspector(contextNode);
            String leftString = inspector.stringValueOf(contextNode);
            if ((argsReversed || !this.test.test(leftString, (Object)rightString)) && (!argsReversed || !this.test.test(rightString, (Object)leftString))) continue;
            return true;
        }
        return false;
    }

    private final boolean nodeSetNumberTest(NodeSet leftNodeSet, Number rightNumber, boolean argsReversed) {
        InspectorManager inspectorManager = InspectorManager.getInstance();
        Iterator iter = leftNodeSet.iterator();
        while (iter.hasNext()) {
            Object contextNode = iter.next();
            INodeInspector inspector = inspectorManager.getInspector(contextNode);
            String leftNodeAsString = inspector.stringValueOf(contextNode);
            Double leftNumber = new Double(NumberFunction.evaluate(leftNodeAsString));
            if ((argsReversed || !this.test.test(leftNumber, (Object)rightNumber)) && (!argsReversed || !this.test.test(rightNumber, (Object)leftNumber))) continue;
            return true;
        }
        return false;
    }

    private final boolean nodeSetBooleanTest(NodeSet leftNodeSet, Boolean rightBoolean, boolean argsReversed) {
        Boolean leftBoolean = BooleanFunction.evaluate(leftNodeSet);
        if (!argsReversed) {
            return this.test.test(leftBoolean, (Object)rightBoolean);
        }
        return this.test.test(rightBoolean, (Object)leftBoolean);
    }

    public abstract String opName();

    public String toString() {
        return "(" + this.left.toString() + this.opName() + this.right.toString() + ")";
    }

    /* synthetic */ RelOp(ExprNode exprNode, ExprNode exprNode2, ITest iTest, RelOp relOp) {
        this(exprNode, exprNode2, iTest);
    }

    public static final class Eq
    extends RelOp {
        public Eq(ExprNode left, ExprNode right) {
            super(left, right, equalsTest, null);
        }

        public String opName() {
            return "=";
        }
    }

    public static final class Gt
    extends RelOp {
        public Gt(ExprNode left, ExprNode right) {
            super(right, left, lessThanTest, null);
        }

        public String opName() {
            return ">";
        }

        public String toString() {
            return "(" + this.right.toString() + this.opName() + this.left.toString() + ")";
        }
    }

    public static final class Gte
    extends RelOp {
        public Gte(ExprNode left, ExprNode right) {
            super(right, left, lessThanOrEqualTest, null);
        }

        public String opName() {
            return ">=";
        }

        public String toString() {
            return "(" + this.right.toString() + this.opName() + this.left.toString() + ")";
        }
    }

    private static interface ITest {
        public boolean test(Boolean var1, Object var2);

        public boolean test(Number var1, Object var2);

        public boolean test(String var1, Object var2);
    }

    public static final class Lt
    extends RelOp {
        public Lt(ExprNode left, ExprNode right) {
            super(left, right, lessThanTest, null);
        }

        public String opName() {
            return "<";
        }
    }

    public static final class Lte
    extends RelOp {
        public Lte(ExprNode left, ExprNode right) {
            super(left, right, lessThanOrEqualTest, null);
        }

        public String opName() {
            return "<=";
        }
    }

    public static final class NotEq
    extends RelOp {
        public NotEq(ExprNode left, ExprNode right) {
            super(left, right, notEqualsTest, null);
        }

        public String opName() {
            return "!=";
        }
    }

    private static abstract class RelativeTest
    implements ITest {
        private RelativeTest() {
        }

        public final boolean test(Boolean b, Object o) {
            return this.test(new Double(NumberFunction.evaluate(b)), o);
        }

        public final boolean test(String s, Object o) {
            return this.test(new Double(NumberFunction.evaluate(s)), o);
        }
    }
}

