/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathRuntimeException;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public class NamespaceUriFunction
implements XPathFunction,
XPathFunctionWithContext {
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("namespace-uri", null, new NamespaceUriFunction(), 0, 1);
    private Context context;

    public Object evaluate(List args) {
        ExpandedName en = null;
        if (args.size() == 0) {
            en = this.context.getContextNodeInspector().expandedNameOf(this.context.getContextNode());
        } else {
            if (!(args.get(0) instanceof NodeSet)) {
                String msg = JET2Messages.XPath_MustBeNodeNodeSet;
                throw new XPathRuntimeException(MessageFormat.format(msg, "namespace-uri"));
            }
            NodeSet nodeSet = (NodeSet)args.get(0);
            if (nodeSet.size() != 0) {
                Object firstNode = nodeSet.iterator().next();
                en = InspectorManager.getInstance().getInspector(firstNode).expandedNameOf(firstNode);
            }
        }
        return en != null ? en.getNamespaceURI() : "";
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

