/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;

public class QualifiedNamesFromIJavaElementCollector {
    private List<String> result;
    private boolean includePackages = false;
    private boolean includeCU = false;
    private boolean includeClassFile = false;

    public QualifiedNamesFromIJavaElementCollector() {
        this(true, true, true);
    }

    public QualifiedNamesFromIJavaElementCollector(boolean includePackages, boolean includeCU, boolean includeClassFiles) {
        this.includePackages = includePackages;
        this.includeCU = includeCU;
        this.includeClassFile = includeClassFiles;
        this.result = new ArrayList<String>();
    }

    public static List<String> collectQualifiedNamesFromSelection(ISelection selection) {
        return new QualifiedNamesFromIJavaElementCollector().getQualifiedNamesFromSelection(selection);
    }

    public List<String> getQualifiedNamesFromSelection(ISelection selection) {
        if (selection instanceof TreeSelection) {
            this.addFromTreeSelection((TreeSelection)selection);
        }
        return this.result;
    }

    private void addFromTreeSelection(TreeSelection selection) {
        for (Object ele : selection) {
            if (ele instanceof IJavaElement) {
                this.scanJavaElement((IJavaElement)ele);
                continue;
            }
            if (!(ele instanceof IProject)) continue;
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)ele));
            this.scanJavaElement((IJavaElement)javaProject);
        }
    }

    private void add(IJavaElement item) {
        this.result.add(this.getQualifiedName(item));
    }

    private String getQualifiedName(IJavaElement item) {
        String res = null;
        switch (item.getElementType()) {
            case 3: {
                res = ((IPackageFragmentRoot)item).getElementName();
                break;
            }
            case 4: {
                res = ((IPackageFragment)item).getElementName();
                break;
            }
            case 5: {
                res = ((ICompilationUnit)item).findPrimaryType().getFullyQualifiedName('.');
                break;
            }
            case 6: {
                res = ((IClassFile)item).getType().getFullyQualifiedName('.');
            }
        }
        return res;
    }

    private void scanCU(ICompilationUnit item) {
        if (this.includeCU) {
            this.add((IJavaElement)item);
        }
    }

    private void scanClassFile(IClassFile item) {
        if (this.includeClassFile) {
            this.add((IJavaElement)item);
        }
    }

    private void scanPackage(IPackageFragment item) {
        if (this.includePackages) {
            this.add((IJavaElement)item);
        }
        try {
            IJavaElement[] iJavaElementArray = item.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.scanJavaElement(child);
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void scanFolder(IPackageFragmentRoot item) {
        try {
            IJavaElement[] iJavaElementArray = item.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.scanJavaElement(child);
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void scanProject(IJavaProject item) {
        try {
            IJavaElement[] iJavaElementArray = item.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.scanJavaElement(child);
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void scanJavaElement(IJavaElement item) {
        switch (item.getElementType()) {
            case 3: {
                this.scanFolder((IPackageFragmentRoot)item);
                break;
            }
            case 4: {
                this.scanPackage((IPackageFragment)item);
                break;
            }
            case 5: {
                this.scanCU((ICompilationUnit)item);
                break;
            }
            case 6: {
                this.scanClassFile((IClassFile)item);
                break;
            }
            case 2: {
                this.scanProject((IJavaProject)item);
            }
        }
    }
}

