/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.export.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.designer.transformation.export.Messages;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.PackageableElement;

public class ExportElementPage
extends WizardPage {
    private final EList<PackageableElement> selectedElements;
    private Text outputPathTxt;
    protected Text fileNameTxt;
    protected Text modelNameTxt;
    private Button outputDirectoryBtn;
    private Button btnCheckButton;
    protected boolean useClosure = false;

    public ExportElementPage(EList<PackageableElement> selectedElements) {
        super(Messages.ExportElements_EXPORT_SELECTED_ELEMENT);
        this.selectedElements = selectedElements;
        this.setDescription(Messages.ExportElements_EXPORT_SELECTED_ELEMENT_NEW_UML);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PackageableElement firstElement = (PackageableElement)this.selectedElements.get(0);
        Label modelNameLbl = new Label(composite, 0);
        modelNameLbl.setText(Messages.ExportElements_NEW_MODEL_NAME);
        this.modelNameTxt = new Text(composite, 2048);
        this.modelNameTxt.setText(PackageUtil.getRootPackage((Element)firstElement).getName());
        this.modelNameTxt.setLayoutData((Object)new GridData(768));
        Label fileNameLbl = new Label(composite, 0);
        fileNameLbl.setText(Messages.ExportElements_FILE_NAME);
        this.fileNameTxt = new Text(composite, 2048);
        this.fileNameTxt.setText(String.valueOf(firstElement.getName()) + ".uml");
        this.fileNameTxt.setLayoutData((Object)new GridData(768));
        Label editorConfLbl = new Label(composite, 0);
        editorConfLbl.setText(Messages.ExportElements_OUTPUT_DIRECTORY);
        Composite output = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        output.setLayout((Layout)layout);
        output.setLayoutData((Object)new GridData(768));
        this.outputPathTxt = new Text(output, 2048);
        this.outputPathTxt.setEnabled(false);
        this.outputPathTxt.setLayoutData((Object)new GridData(768));
        this.outputDirectoryBtn = new Button(output, 0);
        this.outputDirectoryBtn.setText(Messages.ExportElements_SELECT);
        this.btnCheckButton = new Button(composite, 32);
        this.btnCheckButton.setText(Messages.ExportElements_TRANSITIVE_CLOSURE);
        GridLayout dialogLayout = new GridLayout();
        GridData dialogLayoutData = new GridData(1808);
        composite.setLayout((Layout)dialogLayout);
        composite.setLayoutData((Object)dialogLayoutData);
        this.setControl((Control)composite);
        this.hookListeners();
        this.setPageComplete(false);
    }

    private void hookListeners() {
        this.btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportElementPage.this.useClosure = ExportElementPage.this.btnCheckButton.getSelection();
            }
        });
        this.outputDirectoryBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] results;
                ContainerSelectionDialog csDialog = new ContainerSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, Messages.ExportElements_OUTPUT_DIRECTORY);
                if (csDialog.open() == 0 && (results = csDialog.getResult()).length == 1 && results[0] instanceof IPath) {
                    ExportElementPage.this.outputPathTxt.setText(results[0].toString());
                    ExportElementPage.this.setPageComplete(true);
                }
            }
        });
    }

    public URI getOutputURI() {
        String path = String.valueOf(this.outputPathTxt.getText()) + "/" + this.fileNameTxt.getText();
        return URI.createPlatformResourceURI((String)path, (boolean)true);
    }

    public boolean useTransitiveClosure() {
        return this.useClosure;
    }

    public String getModelName() {
        return this.modelNameTxt.getText();
    }
}

