/**
 * Copyright (c) 2016 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Van Cam Pham        <VanCam.PHAM@cea.fr>
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;

@SuppressWarnings("all")
public class PThreadTypes {
  private static final String PTHREAD_COND_T = "pthread::pthread_cond_t";
  
  private static final String PTHREAD_MUTEX_T = "pthread::pthread_mutex_t";
  
  private static final String PTHREAD_T = "pthread::pthread_t";
  
  public PThreadTypes(final org.eclipse.uml2.uml.Class contextClass) {
    this.contextClass = contextClass;
  }
  
  private org.eclipse.uml2.uml.Class contextClass;
  
  public Type getPthreadCond() {
    NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(this.contextClass, PThreadTypes.PTHREAD_COND_T);
    return ((Type) _qualifiedElementFromRS);
  }
  
  public Type getPthreadMutex() {
    NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(this.contextClass, PThreadTypes.PTHREAD_MUTEX_T);
    return ((Type) _qualifiedElementFromRS);
  }
  
  public Type getPthread() {
    NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(this.contextClass, PThreadTypes.PTHREAD_T);
    return ((Type) _qualifiedElementFromRS);
  }
}
