/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.library.utils;

import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.designer.transformation.tracing.library.utils.TraceUtils;
import org.eclipse.papyrus.moka.tracepoint.service.TraceActions;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;

public class ImplicitTrace {
    public static boolean traceOperation(Operation op) {
        Class clazz = op.getClass_();
        IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)clazz);
        if (marker != null) {
            if (TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Class, TraceActions.TAClass.AllOperations.ordinal())) {
                return true;
            }
            if (StereotypeUtil.isApplied((Element)op, Create.class) && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Class, TraceActions.TAClass.Creation.ordinal())) {
                return true;
            }
            if (StereotypeUtil.isApplied((Element)op, Destroy.class) && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Class, TraceActions.TAClass.Destruction.ordinal())) {
                return true;
            }
        }
        return false;
    }

    public static boolean tracePort(Port port) {
        if (port.getProvideds().size() > 0) {
            Class clazz = port.getClass_();
            IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)clazz);
            if (marker != null && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Class, TraceActions.TAClass.AllPorts.ordinal())) {
                return true;
            }
            for (EStructuralFeature.Setting setting : UML2Util.getInverseReferences((EObject)port)) {
                ConnectorEnd connEnd;
                EObject invRef = setting.getEObject();
                if (!(invRef instanceof ConnectorEnd) || (marker = TraceUtils.getMarkerForTraceElement((EObject)(connEnd = (ConnectorEnd)invRef).getOwner())) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean traceState(State state) {
        BehavioredClassifier clazz = state.containingStateMachine().getContext();
        IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)clazz);
        return marker != null && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Class, TraceActions.TAClass.AllStates.ordinal());
    }

    public static boolean traceTransition(Transition transition) {
        IMarker[] markers;
        BehavioredClassifier clazz = transition.containingStateMachine().getContext();
        IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)clazz);
        if (TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Class, TraceActions.TAClass.AllTransitions.ordinal())) {
            return true;
        }
        IMarker[] iMarkerArray = markers = new IMarker[]{TraceUtils.getMarkerForTraceElement((EObject)transition.getSource()), TraceUtils.getMarkerForTraceElement((EObject)transition.getTarget())};
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker stMarker = iMarkerArray[n2];
            if (stMarker != null && TraceUtils.isActionActive(stMarker, TraceActions.TraceFeature.State, TraceActions.TAState.Transition.ordinal())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

