package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.CGenUtils;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class BehaviorScript {
  public static CharSequence returnSpec(final Behavior behavior) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Parameter _returnResult = GenUtils.returnResult(behavior);
      boolean _tripleEquals = (_returnResult == null);
      if (_tripleEquals) {
        _builder.append("void ");
      } else {
        String _modCVQualifier = Modifier.modCVQualifier(GenUtils.returnResult(behavior));
        _builder.append(_modCVQualifier);
        _builder.append(" ");
        String _cppQualifiedName = CGenUtils.cppQualifiedName(GenUtils.returnResult(behavior).getType());
        _builder.append(_cppQualifiedName);
        String _modPtr = Modifier.modPtr(GenUtils.returnResult(behavior));
        _builder.append(_modPtr);
        String _modRef = Modifier.modRef(GenUtils.returnResult(behavior));
        _builder.append(_modRef);
        _builder.append(" ");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence behaviorImplementation(final String name, final OpaqueBehavior behavior) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genComment = CommonScript.genComment(behavior);
    _builder.append(_genComment);
    _builder.newLineIfNotEmpty();
    CharSequence _returnSpec = BehaviorScript.returnSpec(behavior);
    _builder.append(_returnSpec);
    _builder.append(name);
    _builder.append("(");
    CharSequence _behaviorParameters = BehaviorScript.behaviorParameters(behavior, false);
    _builder.append(_behaviorParameters);
    _builder.append(")");
    String _modCVQualifier = Modifier.modCVQualifier(behavior);
    _builder.append(_modCVQualifier);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _bodyFromOB = GenUtils.getBodyFromOB(behavior, FunctionScript.CLANGUAGE);
    _builder.append(_bodyFromOB, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public static String InlineTxt(final Element element) {
    String _xifexpression = null;
    boolean _hasStereotype = GenUtils.hasStereotype(element, Inline.class);
    if (_hasStereotype) {
      _xifexpression = "inline ";
    }
    return _xifexpression;
  }

  public static CharSequence behaviorDeclaration(final String name, final Behavior behavior) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genComment = CommonScript.genComment(behavior);
    _builder.append(_genComment);
    _builder.newLineIfNotEmpty();
    String _InlineTxt = BehaviorScript.InlineTxt(behavior);
    _builder.append(_InlineTxt);
    CharSequence _returnSpec = BehaviorScript.returnSpec(behavior);
    _builder.append(_returnSpec);
    _builder.append(name);
    _builder.append("(");
    CharSequence _behaviorParameters = BehaviorScript.behaviorParameters(behavior, true);
    _builder.append(_behaviorParameters);
    _builder.append(")");
    String _modCVQualifier = Modifier.modCVQualifier(behavior);
    _builder.append(_modCVQualifier);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * comment signature for a given behavior (e.g. effect within state machine)
   */
  public static CharSequence behaviorParameters(final Behavior behavior, final boolean showDefault) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Parameter, Boolean> _function = new Function1<Parameter, Boolean>() {
        @Override
        public Boolean apply(final Parameter it) {
          ParameterDirectionKind _direction = it.getDirection();
          return Boolean.valueOf((!Objects.equal(_direction, ParameterDirectionKind.RETURN_LITERAL)));
        }
      };
      Iterable<Parameter> _filter = IterableExtensions.<Parameter>filter(behavior.getOwnedParameters(), _function);
      boolean _hasElements = false;
      for(final Parameter ownedParameter : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _parameter = BehaviorScript.parameter(ownedParameter, showDefault);
        _builder.append(_parameter);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * C++ parameter. Default values are added, if parameter showDefault is true (implementation signature
   */
  public static String parameter(final Parameter parameter, final boolean showDefault) {
    String _modCVQualifier = Modifier.modCVQualifier(parameter);
    String _modSCQualifier = Modifier.modSCQualifier(parameter);
    String _plus = (_modCVQualifier + _modSCQualifier);
    String _cppQualifiedName = CGenUtils.cppQualifiedName(parameter.getType());
    String _plus_1 = (_plus + _cppQualifiedName);
    String _modPtr = Modifier.modPtr(parameter);
    String _plus_2 = (_plus_1 + _modPtr);
    String _modRef = Modifier.modRef(parameter);
    String _plus_3 = (_plus_2 + _modRef);
    String _dirInfo = Modifier.dirInfo(parameter);
    String _plus_4 = (_plus_3 + _dirInfo);
    String _plus_5 = (_plus_4 + " ");
    String _name = parameter.getName();
    String _plus_6 = (_plus_5 + _name);
    String _modArray = Modifier.modArray(parameter);
    String _plus_7 = (_plus_6 + _modArray);
    String _xifexpression = null;
    if (showDefault) {
      _xifexpression = BehaviorScript.defaultValue(parameter);
    } else {
      _xifexpression = "";
    }
    return (_plus_7 + _xifexpression);
  }

  public static String defaultValue(final Parameter parameter) {
    String _xifexpression = null;
    ValueSpecification _defaultValue = parameter.getDefaultValue();
    boolean _tripleNotEquals = (_defaultValue != null);
    if (_tripleNotEquals) {
      String _stringValue = parameter.getDefaultValue().stringValue();
      _xifexpression = (" = " + _stringValue);
    } else {
      _xifexpression = "";
    }
    return _xifexpression;
  }
}
