/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Visibility;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassInheritedDeclarations {
  public static CharSequence CppClassInheritedDeclarations(final Classifier clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _length = ((Object[])Conversions.unwrapArray(CppClassInheritedDeclarations.filteredRelationships(clazz), Object.class)).length;
      boolean _greaterThan = (_length > 0);
      if (_greaterThan) {
        _builder.append(" : ");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      Iterable<DirectedRelationship> _filteredRelationships = CppClassInheritedDeclarations.filteredRelationships(clazz);
      boolean _hasElements = false;
      for(final DirectedRelationship fr : _filteredRelationships) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", \n", "");
        }
        String _cppVisibility = CppClassInheritedDeclarations.getCppVisibility(fr);
        _builder.append(_cppVisibility);
        _builder.append(" ");
        Element _get = fr.getTargets().get(0);
        String _cppQualifiedName = CppGenUtils.cgu(clazz).cppQualifiedName(((Classifier) _get));
        _builder.append(_cppQualifiedName);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static Iterable<DirectedRelationship> filteredRelationships(final Classifier clazz) {
    final Function1<DirectedRelationship, Boolean> _function = new Function1<DirectedRelationship, Boolean>() {
      @Override
      public Boolean apply(final DirectedRelationship it) {
        return Boolean.valueOf(((((it instanceof Generalization) || (it instanceof InterfaceRealization)) && (it.getTargets().size() > 0)) && (!GenUtils.hasStereotype(it.getTargets().get(0), NoCodeGen.class))));
      }
    };
    return IterableExtensions.<DirectedRelationship>filter(clazz.getSourceDirectedRelationships(), _function);
  }

  public static String getCppVisibility(final Relationship relationship) {
    String _xifexpression = null;
    boolean _hasStereotype = GenUtils.hasStereotype(relationship, Visibility.class);
    if (_hasStereotype) {
      _xifexpression = UMLUtil.<Visibility>getStereotypeApplication(relationship, Visibility.class).getValue();
    } else {
      _xifexpression = "public";
    }
    return _xifexpression;
  }
}
