/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.utils;

import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.base.TestInfo;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageProjectSupport;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Project;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Activator;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.Messages;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LocateCppProject {
    private static final boolean Headless = TestInfo.runsHeadless();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        IProject modelProject;
        block15: {
            Package rootPkg = PackageUtil.getRootPackage((Element)pe);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.designer.languages.cpp.codegen");
            String prefix = prefs != null ? prefs.get("projectPrefix", "org.eclipse.papyrus.cppgen.") : "bad preferences.";
            Project projectStereo = (Project)UMLUtil.getStereotypeApplication((Element)rootPkg, Project.class);
            String projectName = null;
            if (projectStereo != null) {
                projectName = projectStereo.getProjectName();
            }
            if (projectName == null) {
                projectName = String.valueOf(prefix) + rootPkg.getName();
            }
            if (!(modelProject = root.getProject(projectName)).exists()) {
                if (Headless) {
                    try {
                        modelProject.create(null);
                    }
                    catch (CoreException e) {
                        return null;
                    }
                } else {
                    if (!createIfMissing) return null;
                    if (!LocateCppProject.openQuestion(Messages.LocateCppProject_CreateTargetProjectTitle, String.format(Messages.LocateCppProject_CreateTargetProjectDesc, projectName))) return null;
                    boolean bl = true;
                    boolean create = bl;
                    if (!create) return null;
                    ILangProjectSupport langSupport = LanguageProjectSupport.getProjectSupport((String)"C++");
                    if (langSupport == null) return null;
                    modelProject = langSupport.createProject(projectName);
                    langSupport.setSettings(modelProject, langSupport.initialConfigurationData());
                    if (modelProject == null) {
                        return null;
                    }
                }
            }
            if (!modelProject.isOpen()) {
                try {
                    modelProject.open(null);
                }
                catch (CoreException e) {
                    return null;
                }
            }
            if (modelProject.hasNature("org.eclipse.cdt.core.ccnature")) return modelProject;
            if (!createIfMissing) return null;
            if (!Headless) {
                if (!LocateCppProject.openQuestion(Messages.LocateCppProject_ApplyCNatureTitle, Messages.LocateCppProject_ApplyCNatureDesc)) return null;
            }
            boolean bl = true;
            boolean apply = bl;
            if (apply) break block15;
            return null;
        }
        try {
            CProjectNature.addCNature((IProject)modelProject, null);
            CCProjectNature.addCCNature((IProject)modelProject, null);
            return modelProject;
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return modelProject;
    }

    private static boolean openQuestion(final String title, final String message) {
        final boolean[] ret = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ret[0] = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
        return ret[0];
    }
}

