/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class TestVisitor
implements IPDOMVisitor {
    private final char[] name;
    private IProgressMonitor monitor;
    private int monitorCheckCounter;

    public TestVisitor(char[] name) {
        this.name = name;
        this.monitor = new NullProgressMonitor();
    }

    public void setMonitor(IProgressMonitor pm) {
        this.monitor = pm;
    }

    public final boolean visit(IPDOMNode node) throws CoreException {
        PDOMNamedNode pb;
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (node instanceof PDOMNamedNode && (pb = (PDOMNamedNode)node).getDBName().equals(this.name)) {
            System.err.println(pb);
        }
        return false;
    }

    private void checkCancelled() {
        if (++this.monitorCheckCounter % 4096 == 0 && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public final void leave(IPDOMNode node) throws CoreException {
    }
}

