/**
 * Copyright (c) 2016 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Ansgar Radermacher - Initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.idl.codegen;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.idl.codegen.preferences.IDLCodeGenUtils;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class GenIDL3 {
  public static CharSequence genIDL3(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    String _commentHeader = IDLCodeGenUtils.getCommentHeader();
    _builder.append(_commentHeader);
    _builder.newLineIfNotEmpty();
    _builder.append("// IDL3 for component ");
    String _name = clazz.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef D_");
    String _name_1 = clazz.getName();
    _builder.append(_name_1);
    _builder.newLineIfNotEmpty();
    _builder.append("#define D_");
    String _name_2 = clazz.getName();
    _builder.append(_name_2);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _includes = GenIDL2.getIncludes(clazz);
    _builder.append(_includes);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _openNamespaceIDL = Utils.openNamespaceIDL(clazz);
    _builder.append(_openNamespaceIDL);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("component ");
    String _name_3 = clazz.getName();
    _builder.append(_name_3);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      EList<Port> _ownedPorts = clazz.getOwnedPorts();
      for(final Port port : _ownedPorts) {
        {
          EList<Interface> _provideds = port.getProvideds();
          for(final Interface intf : _provideds) {
            _builder.append("\t");
            _builder.append("provide ");
            String _name_4 = intf.getName();
            _builder.append(_name_4, "\t");
            _builder.append(" ");
            String _name_5 = port.getName();
            _builder.append(_name_5, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          EList<Interface> _requireds = port.getRequireds();
          for(final Interface intf_1 : _requireds) {
            _builder.append("\t");
            _builder.append("use ");
            String _name_6 = intf_1.getName();
            _builder.append(_name_6, "\t");
            _builder.append(" ");
            String _name_7 = port.getName();
            _builder.append(_name_7, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("home ");
    String _name_8 = clazz.getName();
    _builder.append(_name_8);
    _builder.append("_home manages ");
    String _name_9 = clazz.getName();
    _builder.append(_name_9);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _closeNamespaceIDL = Utils.closeNamespaceIDL(clazz);
    _builder.append(_closeNamespaceIDL);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
}
