/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.awt.Size;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.XComponentContext;
import org.eclipse.papyrus.model2doc.odt.internal.util.IImageResizer;
import org.eclipse.papyrus.model2doc.odt.internal.util.ImageUtil;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;

public class ConstrainedImageResizer
implements IImageResizer {
    private final int maxWidth;
    private final int maxHeight;

    public ConstrainedImageResizer(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    @Override
    public XTextContent resizeImage(XTextContent graphicContent, String imagePath, XTextDocument xTextDocument, XMultiComponentFactory xMultiComponentFactory, XComponentContext xComponentContext) {
        Size realSizeImage = ImageUtil.getSize100mm(imagePath, xMultiComponentFactory, xComponentContext);
        if (this.maxHeight > 0 && this.maxWidth > 0 && realSizeImage.Width > 0 && realSizeImage.Height > 0) {
            Size resizeImage = new Size(realSizeImage.Width, realSizeImage.Height);
            Size writableSize = new Size(this.maxWidth, this.maxHeight);
            float height = (float)realSizeImage.Height / (float)writableSize.Height;
            float width = (float)realSizeImage.Width / (float)writableSize.Width;
            if (height < width) {
                resizeImage.Height = Math.round((float)resizeImage.Height / width);
                resizeImage.Width = Math.round((float)resizeImage.Width / width);
            }
            if (width < height) {
                resizeImage.Height = Math.round((float)resizeImage.Height / height);
                resizeImage.Width = Math.round((float)resizeImage.Width / height);
            }
            PropertySetUtil.setProperty(graphicContent, "Width", resizeImage.Width);
            PropertySetUtil.setProperty(graphicContent, "Height", resizeImage.Height);
            PropertySetUtil.setProperty(graphicContent, "RelativeHeightRelation", "scale");
            PropertySetUtil.setProperty(graphicContent, "RelativeWidthRelation", "100");
        }
        return graphicContent;
    }
}

