/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.template2pdf.internal.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatus;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.template2document.internal.handler.GenerateStructureAndDocumentHandler;
import org.eclipse.papyrus.model2doc.odt.emf.template2pdf.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.pdf.PDFExporter;
import org.eclipse.papyrus.model2doc.odt.internal.pdf.PDFVersion;

public class GenerateStructureDocumentAndPDFHandler
extends GenerateStructureAndDocumentHandler
implements IExecutableExtension {
    private static final String HANDLER_PARAMETER_ID = "org.eclipse.papyrus.model2doc.odt.emf.template2pdf.pdfVersion";
    private PDFVersion pdfVersion = PDFVersion.PDF_DEFAULT;

    protected IGenerationStatus generate() {
        IGenerationStatus status = super.generate();
        if (status.isOK()) {
            String generatedDocumentPath = (String)status.getAdaptedResult(String.class);
            Assert.isNotNull((Object)generatedDocumentPath);
            PDFExporter exporter = new PDFExporter();
            exporter.setPDFVersion(this.pdfVersion);
            exporter.setOpenEndDialog(false);
            try {
                String pdfPath = exporter.exportToPDF(generatedDocumentPath);
                GenerationStatus newStatus = new GenerationStatus(0, "org.eclipse.papyrus.model2doc.odt.emf.template2pdf", "The generation of pdf file succeed");
                newStatus.setResult((Object)pdfPath);
                return newStatus;
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.odt.emf.template2pdf", "The PDF generation failed with an Exception", (Throwable)e);
            }
        }
        return status;
    }

    protected boolean computeEnable(Object evaluationContext) {
        boolean enable = super.computeEnable(evaluationContext);
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            iEvaluationContext.addVariable("pdfVersionMenuLabelId", (Object)this.pdfVersion.getName());
        }
        return enable;
    }

    protected String createMenuLabel(List<String> labels) {
        labels.add(this.pdfVersion.getName());
        return super.createMenuLabel(labels);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map && HANDLER_PARAMETER_ID != null) {
            this.pdfVersion = PDFVersion.getPDFVersionByString((String)((String)((Map)data).get(HANDLER_PARAMETER_ID)));
        }
        if (this.pdfVersion == null) {
            this.pdfVersion = PDFVersion.PDF_DEFAULT;
        }
    }
}

