/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.commands.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.metrics.commands.Activator;
import org.eclipse.papyrus.metrics.extensionpoints.helpers.Result;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IDefaultQuerySwitch;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IRecognizerSwitch;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IResultsViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.omg.smm.Measure;
import org.omg.smm.Operation;
import org.omg.smm.Scope;

public class MetricsCalculatorHelper {
    protected ArrayList<Measure> measures = new ArrayList();
    protected Element observationScope = null;
    protected ArrayList<IResultsViewer> resultsViewers = null;
    protected ArrayList<Result> observationResults = null;
    protected HashMap<Element, ArrayList<Measure>> measurementScopes = null;
    protected IRecognizerSwitch recognizerSwitch = null;
    protected IDefaultQuerySwitch defaultQuerySwitch = null;

    public MetricsCalculatorHelper(ArrayList<Measure> measures2, Element observationScope2, ArrayList<IResultsViewer> viewers2, IRecognizerSwitch recognizerSwitch2, IDefaultQuerySwitch defaultQuerySwitch2) {
        this.measures = measures2;
        this.observationScope = observationScope2;
        this.resultsViewers = viewers2;
        this.measurementScopes = new HashMap();
        this.observationResults = new ArrayList();
        this.recognizerSwitch = recognizerSwitch2;
        this.defaultQuerySwitch = defaultQuerySwitch2;
    }

    public void run() {
        this.calculateMeasurementScopes(this.observationScope);
        this.performMeasurementProcess();
        this.showMeasures();
    }

    public void calculateMeasurementScopes(Element element) {
        for (Measure measure : this.measures) {
            String operationName;
            if (measure.getScope() == null) {
                Activator.log.warn("There are not scopes associated to the measure " + measure.getName());
                return;
            }
            Scope scope = measure.getScope();
            if (scope.getRecognizer() == null) {
                Activator.log.warn("There are not recognizers associated to the scope " + scope.getName());
                return;
            }
            Operation recognizer = scope.getRecognizer();
            if (!recognizer.getLanguage().contentEquals("Java") || !this.recognizerSwitch.isRecognized(operationName = recognizer.getBody(), element)) continue;
            this.updateMeasurementScopes(element, measure);
            if (element.allOwnedElements() == null) continue;
            for (Element currentElement : element.allOwnedElements()) {
                this.calculateMeasurementScopes(currentElement);
            }
        }
    }

    protected void updateMeasurementScopes(Element element, Measure measure) {
        if (this.measurementScopes.containsKey(element)) {
            if (!this.measurementScopes.get(element).contains(measure)) {
                this.measurementScopes.get(element).add(measure);
            }
        } else {
            this.measurementScopes.put(element, new ArrayList());
            this.measurementScopes.get(element).add(measure);
        }
    }

    public void showMeasures() {
        if (this.observationResults.isEmpty()) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)"There are no measures to calculate for the selected element");
            return;
        }
        for (IResultsViewer resultsViewer : this.resultsViewers) {
            resultsViewer.show(this.observationResults);
        }
    }

    protected void updateOpservationResults(Measure measure, Element measurand, Object value) {
        this.observationResults.add(new Result(measure, measurand, value));
    }

    public void performMeasurementProcess() {
        Iterator<Element> elementKeyiterator = this.measurementScopes.keySet().iterator();
        Object value = null;
        while (elementKeyiterator.hasNext()) {
            Element currentKey = elementKeyiterator.next();
            for (Measure measure : this.measurementScopes.get(currentKey)) {
                if (measure.getDefaultQuery() == null) {
                    Activator.log.warn("There are not default queries associated to the measure " + measure.getName());
                    return;
                }
                Operation operation = measure.getDefaultQuery();
                if (operation.getLanguage().contentEquals("Java")) {
                    String methodNameToExecute = operation.getBody();
                    value = this.defaultQuerySwitch.calculateValue(methodNameToExecute, currentKey);
                }
                this.updateOpservationResults(measure, currentKey, value);
            }
        }
    }
}

