/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.extensionpoints.helpers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.metrics.extensionpoints.Activator;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IDefaultQuerySwitch;

public class DefaultQuerySwitchRegistry {
    protected static DefaultQuerySwitchRegistry defaultQuerySwitchRegistry = null;
    protected IDefaultQuerySwitch defaultQuerySwitch = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.metrics.extensionpoints.defaultqueryswitch";

    public IDefaultQuerySwitch getDefaultQuerySwitch() {
        return this.defaultQuerySwitch;
    }

    public static synchronized DefaultQuerySwitchRegistry getInstance() {
        if (defaultQuerySwitchRegistry == null) {
            defaultQuerySwitchRegistry = new DefaultQuerySwitchRegistry();
            defaultQuerySwitchRegistry.init();
        }
        return defaultQuerySwitchRegistry;
    }

    protected void init() {
        this.defaultQuerySwitch = null;
        this.readExtensions();
    }

    protected void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (elements.length > 1) {
            Activator.log.warn("It is not possible to register more than one default query operations switch");
            return;
        }
        try {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object o = element.createExecutableExtension("class");
                if (o instanceof IDefaultQuerySwitch) {
                    this.defaultQuerySwitch = (IDefaultQuerySwitch)o;
                    return;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

