/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.extensionpoints.helpers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.metrics.extensionpoints.Activator;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IRecognizerSwitch;

public class RecognizerSwitchRegistry {
    protected static RecognizerSwitchRegistry recognizerSwitchRegistry = null;
    protected IRecognizerSwitch recognizerSwitch = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.metrics.extensionpoints.recognizerswitch";

    public IRecognizerSwitch getRecognizerSwitch() {
        return this.recognizerSwitch;
    }

    public static synchronized RecognizerSwitchRegistry getInstance() {
        if (recognizerSwitchRegistry == null) {
            recognizerSwitchRegistry = new RecognizerSwitchRegistry();
            recognizerSwitchRegistry.init();
        }
        return recognizerSwitchRegistry;
    }

    protected void init() {
        this.recognizerSwitch = null;
        this.readExtensions();
    }

    protected void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (elements.length > 1) {
            Activator.log.warn("It is not possible to register more than one recognizer operations switch");
            return;
        }
        try {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object o = element.createExecutableExtension("class");
                if (o instanceof IRecognizerSwitch) {
                    this.recognizerSwitch = (IRecognizerSwitch)o;
                    return;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

