/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.traceability.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.requirements.sysml.common.Utils;
import org.eclipse.papyrus.requirements.sysml.traceability.assistant.analysis.TracabilityAnalyzer;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ApplyTracabilityHandler
extends AbstractHandler {
    protected TransactionalEditingDomain transactionalEditingDomain = null;
    protected Package selectedElement = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        try {
            this.transactionalEditingDomain = (TransactionalEditingDomain)ServiceUtilsForHandlers.getInstance().getService(TransactionalEditingDomain.class, (Object)event);
        }
        catch (Exception e) {
            System.err.println("impossible to get the Transactional Editing Domain " + e);
        }
        if (selection instanceof IStructuredSelection) {
            TransactionalEditingDomain editingDomain;
            Object selectedobject = ((IStructuredSelection)selection).getFirstElement();
            EObject selectedEObject = EMFHelper.getEObject((Object)selectedobject);
            if (selectedEObject instanceof Model) {
                this.selectedElement = (Package)selectedEObject;
            }
            if (this.selectedElement != null && (editingDomain = EditorUtils.getTransactionalEditingDomain()) != null && this.selectedElement != null) {
                RecordingCommand command = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        ApplyTracabilityHandler.this.changeStructure(ApplyTracabilityHandler.this.selectedElement);
                    }
                };
                editingDomain.getCommandStack().execute((Command)command);
                TracabilityAnalyzer analyzer = new TracabilityAnalyzer();
                analyzer.runAnalysis(Utils.getToPackage((Element)this.selectedElement), editingDomain);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    protected void changeStructure(Package currentPackage) {
        Package topPackage = Utils.getToPackage((Element)currentPackage);
        RegisteredProfile SysMLregisteredProfile = (RegisteredProfile)RegisteredProfile.getRegisteredProfile((String)"SysML");
        URI SysMLmodelUri = SysMLregisteredProfile.uri;
        Resource SysMLResource = Util.getResourceSet((EObject)topPackage).getResource(SysMLmodelUri, true);
        Profile sysMLprofile = (Profile)SysMLResource.getContents().get(0);
        topPackage.applyProfile(sysMLprofile);
        URI standardL2URI = URI.createURI((String)"pathmap://UML_PROFILES/StandardL2.profile.uml");
        Resource standardL2Resource = Util.getResourceSet((EObject)topPackage).getResource(standardL2URI, true);
        Profile standardL2Profile = (Profile)standardL2Resource.getContents().get(0);
        topPackage.applyProfile(standardL2Profile);
    }
}

