/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.validation.quickfix;

import java.util.function.Consumer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.sysml16.validation.Activator;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.uml2.uml.Element;

public class ConsumerElementMarkerResolution<T extends Element>
implements IMarkerResolution {
    private String label;
    private Consumer<T> consumer;

    public ConsumerElementMarkerResolution(String label, Consumer<T> consumer) {
        this.label = label;
        this.consumer = consumer;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        try {
            ModelSet currentModelSet;
            EObject eObject;
            Object uri = marker.getAttribute("uri");
            if (uri instanceof String && (eObject = (currentModelSet = ServiceUtilsForHandlers.getInstance().getModelSet(null)).getEObject(URI.createURI((String)((String)uri)), true)) instanceof Element) {
                final Element element = (Element)eObject;
                InternalTransactionalEditingDomain transactionalEditingDomain = (InternalTransactionalEditingDomain)ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)element);
                RecordingCommand unapplyStereotypeCommand = new RecordingCommand((TransactionalEditingDomain)transactionalEditingDomain, this.label){

                    protected void doExecute() {
                        try {
                            ConsumerElementMarkerResolution.this.consumer.accept(element);
                        }
                        catch (ClassCastException e) {
                            Activator.log(e);
                        }
                    }
                };
                transactionalEditingDomain.getCommandStack().execute((Command)unapplyStereotypeCommand);
                marker.delete();
            }
        }
        catch (CoreException | ServiceException e) {
            Activator.log(e);
        }
    }
}

