/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.util;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public final class SysMLResource {
    public static final String PROFILES_PATHMAP = "pathmap://SysML16_PROFILES/";
    public static final String PROFILE_PATH = "pathmap://SysML16_PROFILES/SysML.profile.uml";
    public static final String PROFILE_URI = "http://www.eclipse.org/papyrus/sysml/1.6/SysML";
    public static final String LIBRARIES_PATHMAP = "pathmap://SysML16_LIBRARIES/";
    public static final String LIBRARY_PATH = "pathmap://SysML16_LIBRARIES/SysML-Standard-Library.uml";
    public static final String LIBRARY_ROOT_ID = "SysML.package_packagedElement_Libraries";
    public static final String QUDV_LIBRARY_PATH = "pathmap://SysML16_LIBRARIES/QUDV.uml";
    public static final String QUDV_LIBRARY_ROOT_ID = "QUDV";
    private static final String UNNAMED = "unnamed";

    private SysMLResource() {
    }

    public static Model createSysMLModel(ResourceSet resourceSet) {
        return SysMLResource.createSysMLModel(resourceSet, "unnamed.uml", UNNAMED);
    }

    public static Model createSysMLModel(ResourceSet resourceSet, String resourceName, String modelName) {
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName(modelName);
        Resource resource = resourceSet.createResource(URI.createURI((String)resourceName));
        resource.getContents().add((Object)model);
        Resource standardProfileResource = resourceSet.getResource(URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml"), true);
        Profile umlStdProfile = (Profile)EcoreUtil.getObjectByType((Collection)standardProfileResource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        model.applyProfile(umlStdProfile);
        Resource sysmlProfileResource = resourceSet.getResource(URI.createURI((String)PROFILE_PATH), true);
        Profile sysmlProfile = (Profile)EcoreUtil.getObjectByType((Collection)sysmlProfileResource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        model.applyProfile(sysmlProfile);
        return model;
    }

    public static Package getFirstSysMLMatchingContainerProfiledBySysMLProfile(Element element) {
        return SysMLResource.getFirstMatchingContainerProfiledBy(element, PROFILE_URI);
    }

    public static Package getFirstMatchingContainerProfiledBy(Element element, String profileUri) {
        Package myNearestPackage;
        if (element instanceof Package) {
            Element elementOwner;
            Package pakage = (Package)element;
            EList appliedProfiles = pakage.getAppliedProfiles();
            if (appliedProfiles != null) {
                for (Profile appliedProfile : appliedProfiles) {
                    if (appliedProfile.getURI() == null || appliedProfile.getURI().compareTo(profileUri) != 0) continue;
                    return pakage;
                }
            }
            if ((elementOwner = element.getOwner()) != null) {
                return SysMLResource.getFirstMatchingContainerProfiledBy(elementOwner, profileUri);
            }
        }
        if (element != null && (myNearestPackage = element.getNearestPackage()) != element) {
            return SysMLResource.getFirstMatchingContainerProfiledBy((Element)myNearestPackage, profileUri);
        }
        return null;
    }

    public static boolean isSysMLProfileApplied(Element element) {
        return SysMLResource.isProfiledByProfile(element, PROFILE_URI);
    }

    public static boolean isProfiledByProfile(Element element, String profileUri) {
        return SysMLResource.getFirstMatchingContainerProfiledBy(element, profileUri) != null;
    }
}

