/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementContentProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementTreeViewerFilter;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.TreeObject;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.DecoratedTreeComposite;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.ProfileElementTreeViewerFilterWithPreference;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.ChooseSetStereotypeDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.panels.AppliedStereotypePanel;
import org.eclipse.papyrus.uml.tools.commands.ReorderStereotypeApplicationsCommand;
import org.eclipse.papyrus.uml.types.core.requests.ApplyStereotypeRequest;
import org.eclipse.papyrus.uml.types.core.requests.UnapplyStereotypeRequest;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCompositeOnModel
extends DecoratedTreeComposite
implements ISelectionChangedListener {
    private AppliedStereotypePanel appliedStereotypePanel;
    protected CLabel label;
    private CommandStackListener commandStackListener;
    private final Adapter stereotypeApplicationAdapter = new StereotypeApplicationAdapter();

    public TransactionalEditingDomain getEditingDomain(Element context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public AppliedStereotypeCompositeOnModel(AppliedStereotypePanel parent) {
        super(parent, 0, "Applied stereotypes", true);
        this.appliedStereotypePanel = parent;
    }

    public AppliedStereotypeCompositeOnModel(Composite parent) {
        super(parent, 0, "Applied stereotypes", true);
    }

    protected void addAppliedStereotype() {
        ChooseSetStereotypeDialog dialog = new ChooseSetStereotypeDialog(this.getShell(), this.getElement());
        int result = dialog.open();
        if (result == 0) {
            Element element = this.getElement();
            EList oldStereotypeList = element.getAppliedStereotypes();
            ArrayList newStereotypeList = dialog.getSelectedElements();
            if (!newStereotypeList.equals(oldStereotypeList)) {
                try {
                    TransactionalEditingDomain domain = this.getEditingDomain(element);
                    domain.runExclusive(() -> {
                        CompoundCommand command = new CompoundCommand();
                        for (Stereotype currentStOld : oldStereotypeList) {
                            if (newStereotypeList.contains(currentStOld)) {
                                newStereotypeList.remove(currentStOld);
                                continue;
                            }
                            command.append(this.getUnapplyStereotypeCommand(element, currentStOld, domain));
                        }
                        for (Stereotype currentStereotype : newStereotypeList) {
                            command.append(this.getApplyStereotypeCommand(element, currentStereotype, domain));
                        }
                        if (command.canExecute()) {
                            this.selectionChanged(null);
                            Display.getCurrent().asyncExec(() -> domain.getCommandStack().execute((Command)command));
                        } else {
                            command.dispose();
                        }
                    });
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
                if (this.appliedStereotypePanel != null) {
                    this.appliedStereotypePanel.refresh();
                }
            }
        }
    }

    @Override
    public void addButtonPressed() {
        this.addAppliedStereotype();
    }

    @Override
    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.createStereotypesTree();
        this.removeButton.setToolTipText("Remove stereotype");
        this.addButton.setToolTipText("Apply stereotype");
        return this;
    }

    private void createStereotypesTree() {
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfileElementLabelProvider());
        ArrayList<ViewerFilter> filterToRemove = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.treeViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter currentFilter = viewerFilterArray[n2];
            if (currentFilter instanceof ProfileElementTreeViewerFilter) {
                filterToRemove.add(currentFilter);
            }
            ++n2;
        }
        for (ViewerFilter filter : filterToRemove) {
            this.treeViewer.removeFilter(filter);
        }
        this.treeViewer.addFilter((ViewerFilter)new ProfileElementTreeViewerFilterWithPreference());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected boolean canMoveDown() {
        boolean result;
        boolean bl = result = super.canMoveDown() && this.stereotypeApplicationsCollocated();
        if (result) {
            TreeItem[] selection = this.getSortedSelection(true);
            int indexOfLastSelected = this.getTree().indexOf(selection[0]);
            result = indexOfLastSelected < this.getTree().getItemCount() - 1;
        }
        return result;
    }

    protected final boolean stereotypeApplicationsCollocated() {
        return this.element != null && this.element.getStereotypeApplications().stream().map(EObject::eResource).distinct().count() == 1L;
    }

    @Override
    public void downButtonPressed() {
        if (!this.canMoveDown()) {
            return;
        }
        BasicEList.FastCompare stereotypes = new BasicEList.FastCompare((Collection)this.element.getAppliedStereotypes());
        TreeItem[] treeItemArray = this.getSortedSelection(true);
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof AppliedStereotypeTreeObject) {
                AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)item.getData();
                int index = stereotypes.indexOf((Object)sTO.getStereotype());
                if (index == -1 || index >= stereotypes.size() - 1) {
                    return;
                }
                stereotypes.move(index + 1, (Object)sTO.getStereotype());
            }
            ++n2;
        }
        this.reorderStereotypeApplications(this.element, (EList<Stereotype>)stereotypes);
    }

    @Override
    public void editItem(TreeItem item) {
    }

    public Element getSelected() {
        return this.appliedStereotypePanel.getSelected();
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    protected Boolean isInStereotypeDisplay(Stereotype st) {
        return false;
    }

    public void refreshTreeViewer() {
        this.treeViewer.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            if (this.element != null) {
                ISelection selection = this.treeViewer.getSelection();
                try {
                    this.treeViewer.setInput((Object)new StereotypedElementTreeObject(this.element));
                }
                finally {
                    this.treeViewer.setSelection(selection);
                }
            } else {
                this.treeViewer.setInput(null);
            }
            StereotypedElementTreeObject rTO = (StereotypedElementTreeObject)this.treeViewer.getInput();
            if (rTO == null) {
                return;
            }
            boolean isEditable = this.isEditable();
            if (rTO.getChildren() != null && rTO.getChildren().length > 1) {
                this.upButton.setEnabled(isEditable);
                this.downButton.setEnabled(isEditable);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
            if (rTO.getChildren() != null && rTO.getChildren().length == 0) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(isEditable && this.canRemove());
            }
        }
    }

    @Override
    public void removeButtonPressed() {
        this.unapplyStereotype();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateEnablement();
        if (this.appliedStereotypePanel != null) {
            if (event == null) {
                this.appliedStereotypePanel.setSelectedProperty(null);
                return;
            }
            IStructuredSelection structSelection = (IStructuredSelection)event.getSelection();
            Object selection = structSelection.getFirstElement();
            if (selection instanceof AppliedStereotypePropertyTreeObject) {
                this.appliedStereotypePanel.setSelectedProperty((AppliedStereotypePropertyTreeObject)selection);
            } else {
                this.appliedStereotypePanel.setSelectedProperty(null);
            }
        }
    }

    public void setInput(StereotypedElementTreeObject element) {
        ISelection selection = this.treeViewer.getSelection();
        try {
            this.treeViewer.setInput((Object)element);
        }
        finally {
            this.treeViewer.setSelection(selection);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("StereotypesTree.expandAll")) {
            this.treeViewer.expandAll();
        }
    }

    protected void unapplyStereotype() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection == 0) {
            return;
        }
        TransactionalEditingDomain domain = this.getEditingDomain(this.element);
        try {
            domain.runExclusive(() -> {
                CompoundCommand command = new CompoundCommand();
                ArrayList<AppliedStereotypeTreeObject> stosToRemove = new ArrayList<AppliedStereotypeTreeObject>(nbrOfSelection);
                int i = 0;
                while (i < nbrOfSelection) {
                    TreeItem item = this.getTree().getSelection()[i];
                    if (item.getData() instanceof AppliedStereotypeTreeObject) {
                        AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)item.getData();
                        stosToRemove.add(sTO);
                        command.append(this.getUnapplyStereotypeCommand(this.element, sTO.getStereotype(), domain));
                    }
                    ++i;
                }
                if (command.canExecute()) {
                    stosToRemove.forEach(AppliedStereotypeTreeObject::removeMe);
                    Display.getCurrent().asyncExec(() -> domain.getCommandStack().execute(command.unwrap()));
                } else {
                    command.dispose();
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        if (this.appliedStereotypePanel != null) {
            this.appliedStereotypePanel.refresh();
        }
    }

    @Override
    protected boolean canRemove() {
        return this.canUnapplyStereotype();
    }

    protected boolean canUnapplyStereotype() {
        boolean result = false;
        TreeItem[] selection = this.getTree().getSelection();
        if (selection.length > 0) {
            result = true;
            int i = 0;
            while (result && i < selection.length) {
                TreeItem next = selection[i];
                if (next.getData() instanceof AppliedStereotypeTreeObject) {
                    AppliedStereotypeTreeObject s = (AppliedStereotypeTreeObject)next.getData();
                    result = this.canUnapplyStereotype(this.element, s.getStereotype());
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    protected boolean canMoveUp() {
        boolean result;
        boolean bl = result = super.canMoveUp() && this.stereotypeApplicationsCollocated();
        if (result) {
            TreeItem[] selection = this.getSortedSelection(false);
            result = this.getTree().indexOf(selection[0]) > 0;
        }
        return result;
    }

    protected TreeItem[] getSortedSelection(boolean reversed) {
        TreeItem[] result = this.getTree().getSelection();
        if (result.length > 1) {
            Comparator<TreeItem> order = Comparator.comparing(arg_0 -> ((Tree)this.getTree()).indexOf(arg_0));
            if (reversed) {
                order = order.reversed();
            }
            Arrays.sort(result, order);
        }
        return result;
    }

    @Override
    public void upButtonPressed() {
        if (!this.canMoveUp()) {
            return;
        }
        BasicEList.FastCompare stereotypes = new BasicEList.FastCompare((Collection)this.element.getAppliedStereotypes());
        TreeItem[] treeItemArray = this.getSortedSelection(false);
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof AppliedStereotypeTreeObject) {
                AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)item.getData();
                int index = stereotypes.indexOf((Object)sTO.getStereotype());
                if (index < 1) {
                    return;
                }
                stereotypes.move(index - 1, (Object)sTO.getStereotype());
            }
            ++n2;
        }
        this.reorderStereotypeApplications(this.element, (EList<Stereotype>)stereotypes);
        if (this.appliedStereotypePanel != null) {
            this.appliedStereotypePanel.refresh();
        }
    }

    @Override
    public void keepSelection(ISelection pSelection) {
        this.getDisplay().asyncExec((Runnable)new SelectionKeeper(pSelection));
    }

    @Deprecated(since="4.1", forRemoval=true)
    public void applyStereotype(final Element elt, final Stereotype st) {
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(elt);
            domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            domain.getCommandStack().execute(AppliedStereotypeCompositeOnModel.this.getApplyStereotypeCommand(elt, st, domain));
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Deprecated(since="4.1", forRemoval=true)
    protected void unapplyStereotype(final Element elt, final Stereotype st) {
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(elt);
            domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            domain.getCommandStack().execute(AppliedStereotypeCompositeOnModel.this.getUnapplyStereotypeCommand(elt, st, domain));
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected boolean canUnapplyStereotype(Element element, Stereotype stereotype) {
        boolean result = false;
        try {
            if (element.isStereotypeApplied(stereotype)) {
                TransactionalEditingDomain domain = this.getEditingDomain(element);
                Command unapply = this.getUnapplyStereotypeCommand(element, stereotype, domain);
                result = unapply != null && unapply.canExecute();
            }
        }
        catch (Exception e) {
            Activator.log.error("Failed to determine whether stereotype can be unapplied.", (Throwable)e);
        }
        return result;
    }

    public void reorderStereotypeApplications(final Element element, final EList<Stereotype> stereotypes) {
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(element);
            domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    ReorderStereotypeApplicationsCommand command = new ReorderStereotypeApplicationsCommand(element, (List)stereotypes);
                    Display.getCurrent().asyncExec(new Runnable((Command)command){
                        private final /* synthetic */ Command val$command;
                        {
                            this.val$command = command;
                        }

                        @Override
                        public void run() {
                            domain.getCommandStack().execute(this.val$command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected Command getApplyStereotypeCommand(Element elt, Stereotype st, TransactionalEditingDomain domain) {
        ApplyStereotypeRequest request;
        ICommand editCommand;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)elt);
        if (edit != null && (editCommand = edit.getEditCommand((IEditCommandRequest)(request = new ApplyStereotypeRequest(elt, st, domain)))) != null && editCommand.canExecute()) {
            result = (Command)ICommandWrapper.wrap((Object)editCommand, Command.class);
        }
        return result;
    }

    protected Command getUnapplyStereotypeCommand(Element elt, Stereotype st, TransactionalEditingDomain domain) {
        UnapplyStereotypeRequest request;
        ICommand editCommand;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)elt);
        if (edit != null && (editCommand = edit.getEditCommand((IEditCommandRequest)(request = new UnapplyStereotypeRequest(elt, st, domain)))) != null && editCommand.canExecute()) {
            result = (Command)ICommandWrapper.wrap((Object)editCommand, Command.class);
        }
        return result;
    }

    @Override
    public void setElement(Element element) {
        Element oldElement = this.getElement();
        if (element == null && oldElement != null) {
            this.getEditingDomain(oldElement).getCommandStack().removeCommandStackListener(this.commandStackListener);
        }
        if (element != null && this.commandStackListener == null) {
            this.commandStackListener = new LocalCommandStackListener();
            this.getEditingDomain(element).getCommandStack().addCommandStackListener(this.commandStackListener);
        }
        if (oldElement != null) {
            oldElement.eAdapters().remove((Object)this.stereotypeApplicationAdapter);
        }
        if (element != null) {
            element.eAdapters().add((Object)this.stereotypeApplicationAdapter);
        }
        super.setElement(element);
    }

    @Override
    public void dispose() {
        Element oldElement = this.getElement();
        if (this.commandStackListener != null && oldElement != null) {
            this.getEditingDomain(this.getElement()).getCommandStack().removeCommandStackListener(this.commandStackListener);
            this.commandStackListener = null;
        }
        if (oldElement != null) {
            oldElement.eAdapters().remove((Object)this.stereotypeApplicationAdapter);
        }
        super.dispose();
    }

    private class LocalCommandStackListener
    implements CommandStackListener {
        private LocalCommandStackListener() {
        }

        public void commandStackChanged(EventObject event) {
            Runnable runRefresh = new Runnable(){

                @Override
                public void run() {
                    Object first;
                    ISelection selection;
                    if (!((LocalCommandStackListener)LocalCommandStackListener.this).AppliedStereotypeCompositeOnModel.this.treeViewer.getTree().isDisposed() && (selection = ((LocalCommandStackListener)LocalCommandStackListener.this).AppliedStereotypeCompositeOnModel.this.treeViewer.getSelection()) instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof AppliedStereotypePropertyTreeObject) {
                        AppliedStereotypeCompositeOnModel.this.refreshTreeViewer();
                    }
                }
            };
            AppliedStereotypeCompositeOnModel.this.treeViewer.getControl().getDisplay().asyncExec(runRefresh);
        }
    }

    private class SelectionKeeper
    implements Runnable {
        ISelection selection = null;

        public SelectionKeeper(ISelection selection) {
            this.selection = selection;
        }

        @Override
        public void run() {
            Object[] vSelectedElements = this.extractSelectedElements(this.selection);
            Object[] vCorrespondingElements = this.getCorrespondingElements(vSelectedElements);
            StructuredSelection vSelection = new StructuredSelection(vCorrespondingElements);
            AppliedStereotypeCompositeOnModel.this.treeViewer.setSelection((ISelection)vSelection);
        }

        private Object[] getCorrespondingElements(Object[] vSelectedElements) {
            StereotypedElementTreeObject vStereotypesTree = (StereotypedElementTreeObject)AppliedStereotypeCompositeOnModel.this.treeViewer.getInput();
            ArrayList<AppliedStereotypeTreeObject> vReturn = new ArrayList<AppliedStereotypeTreeObject>();
            Object[] objectArray = vSelectedElements;
            int n = vSelectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object vStereotype = objectArray[n2];
                if (vStereotype instanceof AppliedStereotypeTreeObject) {
                    AppliedStereotypeTreeObject vTreeObject = this.findAppliedStereotypeInTree(((AppliedStereotypeTreeObject)vStereotype).getStereotype(), vStereotypesTree);
                    vReturn.add(vTreeObject);
                }
                ++n2;
            }
            return vReturn.toArray();
        }

        private AppliedStereotypeTreeObject findAppliedStereotypeInTree(Stereotype stereotype, StereotypedElementTreeObject vStereotypesTree) {
            AppliedStereotypeTreeObject vAppliedStereotypeObject = null;
            TreeObject[] treeObjectArray = vStereotypesTree.getChildren();
            int n = treeObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeObject vChild = treeObjectArray[n2];
                if (vChild instanceof AppliedStereotypeTreeObject && stereotype.equals(((AppliedStereotypeTreeObject)vChild).getStereotype())) {
                    vAppliedStereotypeObject = (AppliedStereotypeTreeObject)vChild;
                }
                ++n2;
            }
            return vAppliedStereotypeObject;
        }

        private Object[] extractSelectedElements(ISelection pSelection) {
            ArrayList<Object> vObjectsList = new ArrayList<Object>();
            if (pSelection instanceof IStructuredSelection) {
                vObjectsList.addAll(Arrays.asList(((IStructuredSelection)pSelection).toArray()));
            }
            return vObjectsList.toArray();
        }
    }

    private class StereotypeApplicationAdapter
    extends AdapterImpl {
        private final Set<Notifier> additionalTargets = new HashSet<Notifier>();

        private StereotypeApplicationAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            if (newTarget instanceof Element) {
                super.setTarget(newTarget);
                this.scope((Element)newTarget).forEach(this::addAdapter);
            }
        }

        private void addAdapter(Notifier target) {
            if (target.eAdapters().add((Object)this)) {
                this.additionalTargets.add(target);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof Element) {
                this.scope((Element)oldTarget).forEach(this::removeAdapter);
                super.unsetTarget(oldTarget);
            }
        }

        private void removeAdapter(Notifier target) {
            if (target.eAdapters().remove((Object)this)) {
                this.additionalTargets.remove(target);
            }
        }

        private Stream<Resource> scope(Element element) {
            return Stream.concat(Stream.of(element.eResource()), element.getStereotypeApplications().stream().map(EObject::eResource)).filter(Objects::nonNull).distinct();
        }

        public void notifyChanged(Notification msg) {
            if (!msg.isTouch() && msg.getFeatureID(Resource.class) == 2 && this.additionalTargets.contains(msg.getNotifier())) {
                AppliedStereotypeCompositeOnModel.this.asyncRefresh();
            }
        }
    }
}

