/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalCommandStack;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.utils.IExecutorPolicy;

class TransactionPrecommitExecutor
implements Executor,
TransactionalEditingDomainListener {
    private final TransactionalEditingDomain editingDomain;
    private final Executor fallback;
    private final AtomicBoolean writeActive = new AtomicBoolean();
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final IExecutorPolicy policy;
    private final Map<?, ?> options;
    private final AtomicBoolean disposed = new AtomicBoolean();

    TransactionPrecommitExecutor(TransactionalEditingDomain domain, Executor fallback, IExecutorPolicy policy, Map<?, ?> options) {
        this.editingDomain = domain;
        this.fallback = fallback;
        this.policy = policy == null ? IExecutorPolicy.NULL : policy;
        this.options = options != null && options.isEmpty() ? null : options;
        ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.Lifecycle.class)).addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
    }

    public void dispose() {
        TransactionalEditingDomain.Lifecycle lifecycle;
        if (this.disposed.compareAndSet(false, true) && (lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.editingDomain, TransactionalEditingDomain.Lifecycle.class)) != null) {
            lifecycle.removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }
    }

    @Override
    public void execute(Runnable command) {
        if (this.disposed.get()) {
            return;
        }
        if (this.writeActive.get() && this.selectSelf(command)) {
            this.queue.offer(command);
        } else {
            this.fallback.execute(command);
        }
    }

    private boolean selectSelf(Runnable task) {
        return IExecutorPolicy.Ranking.select(this.policy, task, this, this.fallback) == this;
    }

    public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
        this.queue.clear();
    }

    public void transactionStarted(TransactionalEditingDomainEvent event) {
        Transaction transaction = event.getTransaction();
        this.writeActive.set(!transaction.isReadOnly() && this.hasTriggersEnabled(transaction));
    }

    private boolean hasTriggersEnabled(Transaction transaction) {
        Map options = transaction.getOptions();
        return !Boolean.TRUE.equals(options.get("unprotected")) && !Boolean.TRUE.equals(options.get("no_triggers")) && !Boolean.TRUE.equals(options.get("is_undo_redo_transaction"));
    }

    public void transactionClosed(TransactionalEditingDomainEvent event) {
        this.writeActive.set(false);
        if (this.queue.peek() != null) {
            Runnable next = (Runnable)this.queue.poll();
            while (next != null) {
                this.fallback.execute(next);
                next = (Runnable)this.queue.poll();
            }
        }
    }

    public void transactionStarting(TransactionalEditingDomainEvent event) {
    }

    public void transactionInterrupted(TransactionalEditingDomainEvent event) {
    }

    public void transactionClosing(TransactionalEditingDomainEvent event) {
        if (this.queue.peek() != null) {
            RecordingCommand trigger = new RecordingCommand(event.getSource(), "Deferred Tasks"){

                protected void doExecute() {
                    Runnable next = (Runnable)TransactionPrecommitExecutor.this.queue.poll();
                    while (next != null) {
                        try {
                            next.run();
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in transaction pre-commit task.", (Throwable)e);
                        }
                        next = (Runnable)TransactionPrecommitExecutor.this.queue.poll();
                    }
                }
            };
            Transaction transaction = event.getTransaction();
            Command triggeringCommand = transaction instanceof EMFCommandTransaction ? ((EMFCommandTransaction)transaction).getCommand() : null;
            InternalTransactionalCommandStack stack = (InternalTransactionalCommandStack)event.getSource().getCommandStack();
            try {
                Map options = transaction.getOptions();
                HashMap mergedOptions = null;
                if (this.options != null) {
                    options = mergedOptions == null ? (mergedOptions = Maps.newHashMap((Map)options)) : mergedOptions;
                    mergedOptions.putAll(this.options);
                }
                if (transaction.isReadOnly()) {
                    options = mergedOptions == null ? (mergedOptions = Maps.newHashMap((Map)options)) : mergedOptions;
                    mergedOptions.put("unprotected", true);
                }
                stack.executeTriggers(triggeringCommand, Collections.singletonList(trigger), options);
            }
            catch (Exception e) {
                Activator.log.error("Failed to execute transaction pre-commit tasks.", (Throwable)e);
            }
        }
    }
}

