/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.editor.actionbarcontributor.IMultiPageEditorActionBarContributor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ActivePageTracker;
import org.eclipse.papyrus.infra.core.sasheditor.internal.EditorPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy.MultiPageSelectionProvider;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class ActiveEditorServicesSwitcher
implements ActivePageTracker.IActiveEditorChangedListener {
    protected PagePart activeEditor;
    private IEditorSite outerEditorSite;
    private INestable activeServiceLocator;

    public ActiveEditorServicesSwitcher(IEditorSite outerEditorSite) {
        this.outerEditorSite = outerEditorSite;
    }

    private IEditorPart getActiveIEditorPart() {
        return this.getIEditorPart(this.activeEditor);
    }

    private IEditorPart getIEditorPart(PagePart pagePart) {
        if (pagePart == null) {
            return null;
        }
        if (pagePart instanceof EditorPart) {
            return ((EditorPart)pagePart).getIEditorPart();
        }
        return null;
    }

    @Override
    public void activeEditorChanged(PagePart oldEditor, PagePart newEditor) {
        if (this.activeEditor == newEditor) {
            return;
        }
        this.activeEditor = newEditor;
        IPartService partService = (IPartService)this.getOuterEditorSite().getService(IPartService.class);
        if (newEditor != null && partService.getActivePart() == this.getOuterEditorSite().getPart()) {
            newEditor.setFocus();
        }
        this.deactivateServices(false);
        this.fireChangeEventToActionBarContributor();
        this.propagateSelectionChanged();
        this.activateServices();
        if (newEditor != null) {
            newEditor.setFocus();
        }
    }

    private void propagateSelectionChanged() {
        ISelectionProvider selectionProvider;
        IEditorPart editorPart = this.getActiveIEditorPart();
        if (editorPart != null && (selectionProvider = editorPart.getSite().getSelectionProvider()) != null) {
            ISelectionProvider outerProvider = this.getOuterEditorSite().getSelectionProvider();
            if (outerProvider instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
                MultiPageSelectionProvider provider = (MultiPageSelectionProvider)outerProvider;
                provider.fireSelectionChanged(event);
                provider.firePostSelectionChanged(event);
            } else {
                Activator.log.warn(this.getClass().getSimpleName() + " did not propogate selection for " + editorPart.getTitle());
            }
        }
    }

    private void activateServices() {
        IEditorSite serviceLocator;
        IEditorPart editor;
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        if ((editor = this.getActiveIEditorPart()) != null && (serviceLocator = editor.getEditorSite()) instanceof INestable) {
            this.activeServiceLocator = (INestable)serviceLocator;
            this.activeServiceLocator.activate();
        }
    }

    private void deactivateServices(boolean immediate) {
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
    }

    private void fireChangeEventToActionBarContributor() {
        IEditorActionBarContributor contributor = this.getOuterEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof IMultiPageEditorActionBarContributor) {
            ((IMultiPageEditorActionBarContributor)contributor).setActivePage(this.getActiveIEditorPart());
        } else if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(this.getActiveIEditorPart());
        }
    }

    private IEditorSite getOuterEditorSite() {
        return this.outerEditorSite;
    }
}

