/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TypedElement;

public class PropertyServices {
    public boolean noPortLoopDetected(Port port, DSemanticDecorator containerView) {
        boolean loopDetected = false;
        Optional<Classifier> optionalPortType = Optional.ofNullable(port.getType()).filter(Classifier.class::isInstance).map(Classifier.class::cast);
        Optional<StructuredClassifier> optionalContainingClassifier = Optional.ofNullable(containerView.getTarget()).filter(TypedElement.class::isInstance).map(typedElement -> ((TypedElement)typedElement).getType()).filter(StructuredClassifier.class::isInstance).map(StructuredClassifier.class::cast);
        if (optionalContainingClassifier.isPresent() && optionalPortType.isPresent() && (loopDetected = this.detectLoopInPortTypeHierarchy((Classifier)optionalContainingClassifier.get(), optionalPortType.get(), Set.of()))) {
            String containerTargetName = Optional.ofNullable(containerView.getTarget()).filter(NamedElement.class::isInstance).map(NamedElement.class::cast).map(NamedElement::getQualifiedName).orElse("");
            Activator.log.warn(String.format("A potential infinity loop has been detected: The port '%s' that should be displayed in '%s' is typed by '%s' which directly or indirectly references '%s' (the parent container type) through ports type hierarchy.", port.getQualifiedName(), containerTargetName, optionalPortType.get().getQualifiedName(), optionalContainingClassifier.get().getQualifiedName()));
        }
        return !loopDetected;
    }

    private boolean detectLoopInPortTypeHierarchy(Classifier firstType, Classifier currentType, Set<Classifier> visitedTypes) {
        boolean loopDetected = false;
        if (firstType.equals(currentType)) {
            loopDetected = true;
        } else if (!visitedTypes.contains(currentType)) {
            HashSet<Classifier> newVisitedTypes = new HashSet<Classifier>(visitedTypes);
            newVisitedTypes.add(currentType);
            loopDetected = currentType.allAttributes().stream().filter(Port.class::isInstance).map(Port.class::cast).map(TypedElement::getType).filter(Classifier.class::isInstance).map(Classifier.class::cast).filter(type -> this.detectLoopInPortTypeHierarchy(firstType, (Classifier)type, (Set<Classifier>)newVisitedTypes)).findFirst().isPresent();
        }
        return loopDetected;
    }

    public boolean noPropertyLoopDetected(Property property, DSemanticDecorator containerView) {
        boolean loopDetected = false;
        Optional<StructuredClassifier> optionalPropertyType = Optional.ofNullable(property.getType()).filter(StructuredClassifier.class::isInstance).map(StructuredClassifier.class::cast);
        Optional<StructuredClassifier> optionalContainingClassifier = Optional.ofNullable(containerView.getTarget()).filter(TypedElement.class::isInstance).map(typedElement -> ((TypedElement)typedElement).getType()).filter(StructuredClassifier.class::isInstance).map(StructuredClassifier.class::cast);
        if (optionalContainingClassifier.isPresent() && optionalPropertyType.isPresent() && (loopDetected = this.detectLoopInPropertyTypeHierarchy(optionalContainingClassifier.get(), optionalPropertyType.get(), Set.of()))) {
            String containerTargetName = Optional.ofNullable(containerView.getTarget()).filter(NamedElement.class::isInstance).map(NamedElement.class::cast).map(NamedElement::getQualifiedName).orElse("");
            Activator.log.warn(String.format("A potential infinity loop has been detected: The property '%s' that should be displayed in '%s' is typed by '%s' which directly or indirectly references '%s' (the parent container type) through properties type hierarchy.", property.getQualifiedName(), containerTargetName, optionalPropertyType.get().getQualifiedName(), optionalContainingClassifier.get().getQualifiedName()));
        }
        return !loopDetected;
    }

    private boolean detectLoopInPropertyTypeHierarchy(StructuredClassifier firstType, StructuredClassifier currentType, Set<Classifier> visitedTypes) {
        boolean loopDetected = false;
        if (firstType.equals(currentType)) {
            loopDetected = true;
        } else if (!visitedTypes.contains(currentType)) {
            HashSet<Classifier> newVisitedTypes = new HashSet<Classifier>(visitedTypes);
            newVisitedTypes.add((Classifier)currentType);
            loopDetected = currentType.allAttributes().stream().map(TypedElement::getType).filter(StructuredClassifier.class::isInstance).map(StructuredClassifier.class::cast).filter(type -> this.detectLoopInPropertyTypeHierarchy(firstType, (StructuredClassifier)type, (Set<Classifier>)newVisitedTypes)).findFirst().isPresent();
        }
        return loopDetected;
    }
}

