/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCommentViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCommentEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public static final String APPLIED_STEREOTYPE_COMMENT = "AppliedStereotypeComment";
    private Node comment;

    public void activate() {
        super.activate();
        this.subscribe(this.hostView.eContainer());
    }

    public void deactivate() {
        this.unsubscribe(this.hostView.eContainer());
        super.deactivate();
    }

    public void refreshNotationStructure() {
        if (this.hostView != null) {
            this.removeUnappliedStereotypes((View)this.comment);
            if (!this.stereotypeList.isEmpty()) {
                this.refreshStereotypeCommentStructure();
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.comment != null && this.comment.getDiagram() != null) {
            int eventType = notification.getEventType();
            Element object = StereotypeDisplayUtil.getInstance().getCommentSemanticElement((View)this.comment);
            if (eventType == 4 && notification.getOldValue().equals(this.hostView) && object == null) {
                this.executeAppliedStereotypeCommentDeletion((View)this.comment);
            }
            if (this.comment.getTargetEdges() != null && eventType == 4 && notification.getOldValue().equals(this.hostView) && this.comment.getTargetEdges().size() == 0) {
                this.executeAppliedStereotypeCommentDeletion((View)this.comment);
            }
        }
    }

    public void refreshStereotypeCommentStructure() {
        if (this.comment != null) {
            this.removeUnappliedStereotypes((View)this.comment);
        }
        if (!this.stereotypeList.isEmpty()) {
            this.comment = this.createCommentNode();
            if (this.comment != null) {
                for (Stereotype stereotype : this.stereotypeList) {
                    this.refreshStereotypeCompartmentStructure(stereotype);
                    this.subscribe((EObject)this.helper.getStereotypeCompartment((View)this.comment, stereotype));
                    this.refreshStereotypeBraceStructure(stereotype);
                    this.subscribe((EObject)this.helper.getStereotypeBraceCompartment((View)this.comment, stereotype));
                }
            }
        }
    }

    public void removeListener() {
        if (!this.stereotypeList.isEmpty() && this.comment != null) {
            for (Stereotype stereotype : this.stereotypeList) {
                this.unsubscribe((EObject)this.helper.getStereotypeCompartment((View)this.comment, stereotype));
                this.unsubscribe((EObject)this.helper.getStereotypeBraceCompartment((View)this.comment, stereotype));
            }
        }
        super.removeListener();
    }

    protected void refreshStereotypeDisplay() {
        super.refreshStereotypeDisplay();
        this.comment = this.helper.getStereotypeComment(this.hostView);
        if (this.comment != null && this.getAppliedStereotypeCompartmentNumber((View)this.comment) == 0) {
            this.executeAppliedStereotypeCommentDeletion((View)this.comment);
        }
    }

    protected int getAppliedStereotypeCompartmentNumber(View view) {
        int nbVisibleCompartment = 0;
        for (View subview : view.getChildren()) {
            if (!this.helper.isStereotypeBrace((Object)subview) && !this.helper.isStereotypeCompartment((Object)subview)) continue;
            ++nbVisibleCompartment;
        }
        return nbVisibleCompartment;
    }

    public void refreshStereotypeBraceStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostView, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeBraceCompartment(stereotype);
            this.createAppliedStereotypeBraceProperties(stereotype);
        }
    }

    public void refreshStereotypeCompartmentStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment((View)this.comment, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeCompartment(stereotype);
        }
        this.createAppliedStereotypeProperties(stereotype);
    }

    protected void createAppliedStereotypeCompartment(Stereotype stereotype) {
        if (this.comment != null && !this.helper.isCompartmentExist((View)this.comment, stereotype)) {
            this.executeAppliedStereotypeCompartmentCreation(this.hostEditPart, stereotype, "StereotypeCompartment");
        }
    }

    protected void createAppliedStereotypeProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment((View)this.comment, stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeProperty((Node)compartment, property);
            }
        }
    }

    protected void createAppliedStereotypeProperty(Node compartment, Property property) {
        if (property != null && !property.getName().startsWith("base_") && !this.helper.isPropertyExist((View)compartment, property)) {
            this.executeAppliedStereotypePropertyViewCreation(this.hostEditPart, compartment, property);
        }
    }

    protected void createAppliedStereotypeBraceCompartment(Stereotype stereotype) {
        if (this.comment != null && !this.helper.isCompartmentExist((View)this.comment, stereotype)) {
            this.executeAppliedStereotypeCompartmentCreation(this.hostEditPart, stereotype, "StereotypeBrace");
        }
    }

    protected void createAppliedStereotypeBraceProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeBraceCompartment((View)this.comment, stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeBraceProperty((Node)compartment, property);
            }
        }
    }

    private Node createCommentNode() {
        if (this.helper.getStereotypeComment(this.hostView) == null) {
            if (this.getHost() instanceof ConnectionEditPart) {
                this.executeAppliedStereotypeCommentCreation(((ConnectionEditPart)this.getHost()).resolveSemanticElement());
            }
            if (this.getHost() instanceof GraphicalEditPart) {
                this.executeAppliedStereotypeCommentCreation(((GraphicalEditPart)this.getHost()).resolveSemanticElement());
            }
        }
        return this.helper.getStereotypeComment(this.hostView);
    }

    protected void executeAppliedStereotypeCompartmentCreation(IGraphicalEditPart editPart, Stereotype stereotype, String type) {
        CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(editPart.getEditingDomain(), (View)this.comment, stereotype, type);
        this.execute((Command)command);
    }

    protected void executeAppliedStereotypePropertyViewCreation(IGraphicalEditPart editPart, Node compartment, Property stereotypeProperty) {
        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(editPart.getEditingDomain(), (View)compartment, stereotypeProperty, "StereotypeProperty");
        this.execute((Command)command);
    }

    protected void executeAppliedStereotypeCommentCreation(EObject node) {
        LayoutConstraint constraint;
        TransactionalEditingDomain domain = this.hostEditPart.getEditingDomain();
        int x = 200;
        int y = 100;
        if (this.hostEditPart.getModel() instanceof Node && (constraint = ((Node)this.hostEditPart.getModel()).getLayoutConstraint()) instanceof Bounds) {
            x += ((Bounds)constraint).getX();
            y = ((Bounds)constraint).getY();
        }
        if (this.hostEditPart.getModel() instanceof Edge && ((Edge)this.hostEditPart.getModel()).getSource() instanceof Node && (constraint = ((Node)((Edge)this.hostEditPart.getModel()).getSource()).getLayoutConstraint()) instanceof Bounds) {
            x += ((Bounds)constraint).getX();
            y = ((Bounds)constraint).getY() - 100;
        }
        boolean isBorderElement = false;
        if (this.hostEditPart instanceof BorderedBorderItemEditPart) {
            isBorderElement = true;
        }
        if (this.helper.getStereotypeComment((View)this.getHost().getModel()) == null) {
            CreateAppliedStereotypeCommentViewCommand command = new CreateAppliedStereotypeCommentViewCommand(domain, (View)this.hostEditPart.getModel(), x, y, node, isBorderElement);
            this.execute((Command)command);
        }
    }

    protected void executeAppliedStereotypeCommentDeletion(View commentNode) {
        if (commentNode != null && TransactionUtil.getEditingDomain((EObject)commentNode) != null) {
            DeleteCommand command = new DeleteCommand(commentNode);
            this.execute((ICommand)command);
        }
    }

    protected Node getNotationNode() {
        View view;
        Node node = null;
        if (this.hostEditPart != null && (view = this.hostEditPart.getNotationView()) instanceof Node) {
            node = (Node)view;
        }
        return node;
    }
}

