/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.services.resourceloading.IProxyManager;
import org.eclipse.papyrus.infra.services.resourceloading.impl.ProxyManager;

public class OnDemandLoadingModelSet
extends DiResourceSet {
    private Set<URI> uriLoading = new HashSet<URI>();
    private IProxyManager proxyManager = new ProxyManager((ModelSet)this);
    private AbstractBaseModel semanticModel;
    private Set<AbstractBaseModel> requiredModels;

    public void unload() {
        super.unload();
        this.proxyManager.dispose();
        this.semanticModel = null;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        URI resourceURI = uri.trimFragment();
        if (resourceURI.equals(this.getSemanticResourceURI()) || this.isRequired(resourceURI) || this.uriLoading.contains(resourceURI)) {
            return super.getEObject(uri, loadOnDemand);
        }
        if (loadOnDemand) {
            return this.proxyManager.getEObjectFromStrategy(uri);
        }
        return super.getEObject(uri, loadOnDemand);
    }

    Set<AbstractBaseModel> getRequiredModels() {
        if (this.requiredModels == null) {
            this.requiredModels = new ModelsReader().getRequiredModels((ModelSet)this, AbstractBaseModel.class);
        }
        return this.requiredModels;
    }

    boolean isRequired(URI resourceURI) {
        return this.getRequiredModels().stream().map(AbstractBaseModel::getResourceURI).anyMatch(u -> resourceURI.equals(u));
    }

    public void forceUriLoading(URI alwaysLoadedUri) {
        this.uriLoading.add(alwaysLoadedUri);
    }

    private AbstractBaseModel getSemanticModel() {
        if (this.semanticModel == null) {
            this.semanticModel = ILanguageService.getLanguageModels((ModelSet)this).stream().filter(AbstractBaseModel.class::isInstance).map(AbstractBaseModel.class::cast).findAny().orElseGet(() -> new DummyModel());
        }
        return this.semanticModel;
    }

    private URI getSemanticResourceURI() {
        AbstractBaseModel model = this.getSemanticModel();
        return model == null ? null : model.getResourceURI();
    }

    private static class DummyModel
    extends AbstractBaseModel {
        private DummyModel() {
        }

        public String getIdentifier() {
            return "";
        }

        protected String getModelFileExtension() {
            return "\u0000";
        }

        public boolean canPersist(EObject object) {
            return false;
        }

        public void persist(EObject object) {
            throw new IllegalArgumentException("cannot persist " + String.valueOf(object));
        }
    }
}

