/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerNodeDescriptor {
    public abstract EClass getContainerEClass();

    public List<EClass> getPossibleGraphicalChildren() {
        List<EReference> refs = this.getChildrenReferences();
        ArrayList<EClass> result = new ArrayList<EClass>(refs.size());
        for (EReference ref : refs) {
            result.add(ref.getEReferenceType());
        }
        return result;
    }

    public Rectangle getContentArea(IGraphicalEditPart containerPart) {
        Rectangle bounds = containerPart.getContentPane().getBounds().getCopy();
        containerPart.getContentPane().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public abstract List<EReference> getChildrenReferences();

    public abstract IGraphicalEditPart getPartFromView(View var1, DiagramEditPart var2);

    public boolean canIBeGraphicalParentOf(EClass childType) {
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType)) continue;
            return true;
        }
        return false;
    }

    public boolean canIBeModelParentOf(EClass childType) {
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || !reference.isContainment()) continue;
            return true;
        }
        return false;
    }

    public List<EReference> getReferenceFor(EClass childType) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || reference.isContainment()) continue;
            result.add(reference);
        }
        return result;
    }

    public EReference getContainmentReferenceFor(EClass childType) {
        EReference usedReference = null;
        ArrayList<EReference> result = new ArrayList<EReference>();
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || !reference.isContainment() || reference.isDerived()) continue;
            result.add(reference);
        }
        for (EReference ref : result) {
            if (usedReference != null && !ref.getEReferenceType().getEAllSuperTypes().contains((Object)usedReference.getEReferenceType())) continue;
            usedReference = ref;
        }
        return usedReference;
    }
}

