/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.eclipse.papyrus.junit.utils.rules.JavaResource;
import org.eclipse.papyrus.junit.utils.rules.PluginResource;
import org.eclipse.papyrus.junit.utils.rules.ProjectFixture;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractModelFixture<T extends EditingDomain>
extends TestWatcher {
    private final ProjectFixture project = new ProjectFixture();
    private T domain;
    private EObject root;
    private Package model;
    private Class<?> testClass;
    private Iterable<URI> initialResourceURIs;

    public Statement apply(Statement base, Description description) {
        this.testClass = JUnitUtils.getTestClass(description);
        Statement result = super.apply(base, description);
        result = this.project.apply(result, description);
        return result;
    }

    public ProjectFixture getProject() {
        return this.project;
    }

    public T getEditingDomain() {
        return this.domain;
    }

    public void execute(Command command) {
        MatcherAssert.assertThat((String)"Command not executable", (Object)command.canExecute(), (org.hamcrest.Matcher)CoreMatchers.is((Object)true));
        this.getEditingDomain().getCommandStack().execute(command);
    }

    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) {
        MatcherAssert.assertThat((String)"Operation not executable", (Object)operation.canExecute(), (org.hamcrest.Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((String)"No operation history available", (Object)this.getEditingDomain().getCommandStack(), (org.hamcrest.Matcher)CoreMatchers.instanceOf(IWorkspaceCommandStack.class));
        try {
            IWorkspaceCommandStack stack = (IWorkspaceCommandStack)this.getEditingDomain().getCommandStack();
            operation.addContext(stack.getDefaultUndoContext());
            return stack.getOperationHistory().execute(operation, monitor, info);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            Assert.fail((String)("Command execution failed: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public IStatus execute(IUndoableOperation operation) {
        return this.execute(operation, null, null);
    }

    public boolean canUndo() {
        return this.getEditingDomain().getCommandStack().canUndo();
    }

    public void undo() {
        MatcherAssert.assertThat((String)"Cannot undo", (Object)this.canUndo(), (org.hamcrest.Matcher)CoreMatchers.is((Object)true));
        this.getEditingDomain().getCommandStack().undo();
    }

    public boolean canRedo() {
        return this.getEditingDomain().getCommandStack().canRedo();
    }

    public void redo() {
        MatcherAssert.assertThat((String)"Cannot redo", (Object)this.canRedo(), (org.hamcrest.Matcher)CoreMatchers.is((Object)true));
        this.getEditingDomain().getCommandStack().redo();
    }

    public ResourceSet getResourceSet() {
        T domain = this.getEditingDomain();
        return domain == null ? null : domain.getResourceSet();
    }

    public EObject getRoot() {
        return this.root;
    }

    public Package getModel() {
        return this.model;
    }

    public Resource getModelResource() {
        return this.getRoot().eResource();
    }

    public URI getModelResourceURI() {
        return this.getModelResource().getURI();
    }

    public URI getModelURI() {
        return EcoreUtil.getURI((EObject)this.getRoot());
    }

    protected abstract T createEditingDomain();

    protected void starting(Description description) {
        this.domain = this.createEditingDomain();
        Resource main = (Resource)Iterables.getFirst(this.initModelResources(description), null);
        MatcherAssert.assertThat((String)"No main UML resource in model fixture", (Object)main, (org.hamcrest.Matcher)CoreMatchers.notNullValue());
        this.root = (EObject)main.getContents().get(0);
        if (this.root instanceof Package) {
            this.model = (Package)this.root;
        }
        this.initialResourceURIs = null;
        this.didLoadResourceSet();
    }

    protected void didLoadResourceSet() {
    }

    protected Iterable<Resource> initModelResources(Description description) {
        ArrayList result;
        if (this.initialResourceURIs == null) {
            Annotation resourceAnnotation = this.getResourceAnnotation(description);
            ResourceKind kind = ResourceKind.getResourceKind(resourceAnnotation);
            String[] paths = kind.getResourcePaths(resourceAnnotation);
            result = Lists.newArrayListWithCapacity((int)paths.length);
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                result.add(this.initModelResource((IPath)Path.forWindows((String)path), kind));
                ++n2;
            }
            ArrayList uris = Lists.newArrayListWithCapacity((int)result.size());
            for (Resource next : result) {
                uris.add(next.getURI());
            }
            this.initialResourceURIs = uris;
            ModelSet modelSet = (ModelSet)TypeUtils.as((Object)this.getResourceSet(), ModelSet.class);
            if (modelSet != null) {
                try {
                    modelSet.loadModels(((Resource)result.get(0)).getURI());
                }
                catch (ModelMultiException e) {
                    e.printStackTrace();
                }
            }
        } else {
            boolean bootstrapResourceSet;
            ResourceSet rset = this.getResourceSet();
            boolean bl = bootstrapResourceSet = rset == null;
            if (bootstrapResourceSet) {
                rset = new ResourceSetImpl();
                rset.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
                rset.getLoadOptions().put("LAX_FEATURE_PROCESSING", true);
            }
            result = Lists.newArrayList();
            try {
                for (URI next : this.initialResourceURIs) {
                    result.add(rset.getResource(next, true));
                }
            }
            finally {
                if (bootstrapResourceSet) {
                    EMFHelper.unload((ResourceSet)rset);
                }
            }
        }
        return result;
    }

    private Resource initModelResource(IPath resourcePath, ResourceKind kind) {
        String targetResourceName = "model";
        if (this.isDIModel(resourcePath)) {
            targetResourceName = resourcePath.removeFileExtension().lastSegment();
        }
        return this.initModelResource(targetResourceName, kind, resourcePath.toString());
    }

    protected boolean isDIModel(IPath path) {
        String fileExtension = path.getFileExtension();
        return "di".equals(fileExtension);
    }

    protected Resource initModelResource(String targetPath, ResourceKind resourceKind, String resourcePath) {
        boolean bootstrapResourceSet;
        Resource result = null;
        ResourceSet resourceSet = this.getResourceSet();
        boolean bl = bootstrapResourceSet = resourceSet == null;
        if (bootstrapResourceSet) {
            resourceSet = new ResourceSetImpl();
            resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
            resourceSet.getLoadOptions().put("LAX_FEATURE_PROCESSING", true);
        }
        HashSet toUnload = Sets.newHashSet();
        try {
            Path resourceIPath = Path.forWindows((String)resourcePath);
            if (this.isDIModel((IPath)resourceIPath)) {
                resourceIPath = resourceIPath.removeFileExtension();
                Map<IPath, Boolean> manifest = this.loadManifest(resourceKind, (IPath)resourceIPath);
                for (Map.Entry<IPath, Boolean> next : manifest.entrySet()) {
                    Resource resource = this.doInitModelResource(resourceSet, targetPath, resourceKind, next.getKey());
                    if (result == null && "uml".equals(next.getKey().getFileExtension())) {
                        result = resource;
                    }
                    if (next.getValue().booleanValue()) continue;
                    toUnload.add(resource);
                }
            } else {
                result = this.doInitModelResource(resourceSet, targetPath, resourceKind, (IPath)resourceIPath);
            }
            if (result == null) {
                Assert.fail((String)"No UML resource in test model");
            }
            LinkedList<Resource> dependents = new LinkedList<Resource>();
            HashSet<Resource> scanned = new HashSet<Resource>();
            dependents.add(result);
            boolean loadedProfiles = false;
            Resource dependent = (Resource)dependents.poll();
            while (dependent != null) {
                if (scanned.add(dependent)) {
                    URI baseURI = result.getURI().trimSegments(1);
                    if (!baseURI.isPrefix()) {
                        baseURI = baseURI.appendSegment("");
                    }
                    for (EObject proxy : EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)dependent).keySet()) {
                        Resource dependency;
                        URI dependencyURI = EcoreUtil.getURI((EObject)proxy).trimFragment();
                        if (!dependencyURI.toString().startsWith(baseURI.toString()) || (dependency = resourceSet.getResource(dependencyURI, false)) != null && dependency.isLoaded() && dependency.getErrors().isEmpty()) continue;
                        URI relative = dependencyURI.deresolve(baseURI);
                        IPath depPath = resourceIPath.removeLastSegments(1).append(URI.decode((String)relative.toString()));
                        if (!resourceKind.exists(this.testClass, depPath)) continue;
                        if (dependency == null) {
                            dependency = resourceSet.createResource(dependencyURI);
                        } else {
                            dependency.unload();
                        }
                        dependency = this.doInitModelResource(resourceSet, URI.decode((String)relative.toString()), resourceKind, depPath);
                        loadedProfiles = loadedProfiles || Iterables.any((Iterable)dependency.getContents(), (Predicate)Predicates.instanceOf(Profile.class));
                        dependents.add(dependency);
                    }
                }
                dependent = (Resource)dependents.poll();
            }
            if (loadedProfiles && Iterables.any((Iterable)result.getContents(), (Predicate)Predicates.instanceOf(AnyType.class))) {
                try {
                    result.unload();
                    result.load(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Error re-loading resource to resolve stereotype schema: " + e.getLocalizedMessage()));
                }
            }
            for (Resource next : toUnload) {
                next.unload();
                next.getResourceSet().getResources().remove((Object)next);
                next.eAdapters().clear();
            }
        }
        finally {
            if (bootstrapResourceSet) {
                EMFHelper.unload((ResourceSet)resourceSet);
            }
        }
        return result;
    }

    private Map<IPath, Boolean> loadManifest(ResourceKind resourceKind, IPath resourceIPath) {
        Map<Object, Object> result = null;
        IPath manifestPath = resourceIPath.addFileExtension("manifest");
        URL manifestURL = resourceKind.getResourceURL(this.testClass, manifestPath);
        if (manifestURL != null) {
            try {
                result = this.parseManifest(manifestPath.removeLastSegments(1), manifestURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result == null) {
            result = Maps.newHashMap();
            IPath basePath = manifestPath.removeFileExtension();
            result.put(basePath.addFileExtension("di"), true);
            result.put(basePath.addFileExtension("uml"), true);
            result.put(basePath.addFileExtension("notation"), true);
        }
        return result;
    }

    private Map<IPath, Boolean> parseManifest(IPath baseResourcePath, URL manifestURL) throws IOException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ImmutableList lines = Resources.asByteSource((URL)manifestURL).asCharSource(Charsets.UTF_8).readLines();
        Pattern pattern = Pattern.compile("([^=]+)(?:=(true|false))?");
        Matcher m = pattern.matcher("");
        for (String line : lines) {
            m.reset(line);
            if (!m.matches()) continue;
            IPath path = baseResourcePath.append(m.group(1));
            boolean load = true;
            if (m.group(2) != null) {
                load = Boolean.valueOf(m.group(2));
            }
            result.put(path, load);
        }
        return result;
    }

    private Resource doInitModelResource(ResourceSet resourceSet, String targetPath, ResourceKind resourceKind, IPath resourceIPath) {
        URI modelURI;
        Resource result;
        Path targetIPath = new Path(targetPath);
        if (!resourceIPath.getFileExtension().equals(targetIPath.getFileExtension())) {
            targetIPath = targetIPath.addFileExtension(resourceIPath.getFileExtension());
        }
        if (!targetIPath.lastSegment().equals(resourceIPath.lastSegment())) {
            targetIPath = targetIPath.removeLastSegments(1).append(resourceIPath.lastSegment());
        }
        if ((result = resourceSet.getResource(modelURI = this.project.getURI((IPath)targetIPath), false)) == null) {
            String extension = modelURI.fileExtension();
            result = "di".equals(extension) || "uml".equals(extension) || "notation".equals(extension) ? resourceSet.createResource(modelURI) : resourceSet.createResource(modelURI, "org.eclipse.uml2.uml");
        }
        if (!result.isLoaded()) {
            ModelSet modelSet;
            if (resourceSet instanceof ModelSet && (modelSet = (ModelSet)resourceSet).getURIWithoutExtension() == null) {
                modelSet.getInternal().setPrimaryModelResourceURI(modelURI);
            }
            try {
                InputStream input = resourceKind.getResourceURL(this.testClass, resourceIPath).openStream();
                OutputStream output = resourceSet.getURIConverter().createOutputStream(result.getURI());
                try {
                    ByteStreams.copy((InputStream)input, (OutputStream)output);
                }
                finally {
                    input.close();
                    output.close();
                }
                result.load(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to load test resource: " + resourceIPath.toString()));
            }
        }
        return result;
    }

    protected void finished(Description description) {
        ResourceSet resourceSet = this.getResourceSet();
        this.initialResourceURIs = null;
        this.model = null;
        this.root = null;
        if (this.domain instanceof TransactionalEditingDomain) {
            ((TransactionalEditingDomain)this.domain).dispose();
        }
        this.domain = null;
        if (resourceSet != null) {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
    }

    private Annotation getResourceAnnotation(Description description) {
        Annotation result = JUnitUtils.getAnyAnnotation(description, JavaResource.class, PluginResource.class);
        MatcherAssert.assertThat((String)"No JavaResource or PluginResource annotation found on test.", (Object)result, (org.hamcrest.Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public static enum ResourceKind {
        JAVA,
        BUNDLE;


        static ResourceKind getResourceKind(Annotation resourceAnnotation) {
            return resourceAnnotation instanceof JavaResource ? JAVA : (resourceAnnotation instanceof PluginResource ? BUNDLE : null);
        }

        String[] getResourcePaths(Annotation resourceAnnotation) {
            switch (this) {
                case JAVA: {
                    return ((JavaResource)resourceAnnotation).value();
                }
                case BUNDLE: {
                    PluginResource plugin = (PluginResource)resourceAnnotation;
                    return plugin.bundle().isEmpty() ? plugin.value() : (String[])Stream.of(plugin.value()).map(path -> String.format("%s:%s", plugin.bundle(), path)).toArray(String[]::new);
                }
            }
            Assert.fail((String)("Not a resource annotation: " + resourceAnnotation));
            return null;
        }

        boolean exists(Class<?> context, IPath path) {
            return this.getResourceURL(context, path) != null;
        }

        URL getResourceURL(Class<?> context, IPath path) {
            URL result = null;
            switch (this) {
                case JAVA: {
                    result = context.getResource(path.toString());
                    break;
                }
                case BUNDLE: {
                    result = this.getBundleURL(context, path);
                }
            }
            return result;
        }

        private URL getBundleURL(Class<?> testClass, IPath resourcePath) {
            Object search;
            URL result = null;
            String bundleID = resourcePath.getDevice();
            if (bundleID != null) {
                resourcePath = resourcePath.setDevice(null);
                int colon = bundleID.lastIndexOf(58);
                if (colon >= 0) {
                    bundleID = bundleID.substring(0, colon);
                }
            }
            String pattern = resourcePath.lastSegment();
            Bundle testBundle = bundleID != null ? Platform.getBundle((String)bundleID) : FrameworkUtil.getBundle(testClass);
            Enumeration urls = testBundle.findEntries((search = resourcePath.segmentCount() > 1 ? resourcePath.removeLastSegments(1) : Path.ROOT).toPortableString(), pattern, false);
            if (urls != null && urls.hasMoreElements()) {
                result = (URL)urls.nextElement();
            }
            if (result == null) {
                Bundle lastBundle = testBundle;
                Class<?> baseClass = testClass.getSuperclass();
                while (baseClass != null) {
                    testBundle = FrameworkUtil.getBundle(baseClass);
                    if (testBundle == null) break;
                    if (testBundle != lastBundle) {
                        lastBundle = testBundle;
                        urls = testBundle.findEntries(search.toPortableString(), pattern, false);
                        if (urls != null && urls.hasMoreElements()) {
                            result = (URL)urls.nextElement();
                        }
                    }
                    baseClass = baseClass.getSuperclass();
                }
            }
            return result;
        }
    }
}

