/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;
import org.eclipse.papyrus.infra.properties.ui.listeners.IPropertiesListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ILabeledModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesUtil;
import org.eclipse.papyrus.infra.properties.ui.widgets.CustomizablePropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public abstract class AbstractPropertyEditor
implements IChangeListener,
CustomizablePropertyEditor {
    protected String propertyPath;
    protected DataSource input;
    private IDataSourceListener dataSourceListener;
    protected boolean readOnly = false;
    protected boolean isEditable = true;
    protected AbstractListEditor listEditor;
    protected AbstractValueEditor valueEditor;
    protected IObservableList observableList;
    protected IObservableValue observableValue;
    protected IValidator modelValidator;
    protected IConverter targetToModelConverter;
    protected boolean showLabel = true;
    protected String customLabel;
    public static int descriptionMaxCharPerLine = 200;
    private static final String LIST_SEPARATOR = ",";
    private static final String BUNDLE_SEPARATOR = "/";
    protected String listeningPropertyPaths;
    protected Set<String> listeningPropertyPathsSet;
    protected String listenerClasses;
    protected Set<IPropertiesListener> listenerClassesSet;

    protected AbstractPropertyEditor() {
    }

    protected AbstractPropertyEditor(AbstractListEditor editor) {
        this.setEditor(editor);
    }

    protected AbstractPropertyEditor(AbstractValueEditor editor) {
        this.setEditor(editor);
    }

    protected void setEditor(AbstractListEditor editor) {
        this.listEditor = editor;
        this.addDisposeListener((AbstractEditor)editor);
    }

    protected void setEditor(AbstractValueEditor editor) {
        this.valueEditor = editor;
        this.addDisposeListener((AbstractEditor)editor);
    }

    private void addDisposeListener(AbstractEditor editor) {
        editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractPropertyEditor.this.input != null) {
                    AbstractPropertyEditor.this.input.removeChangeListener(AbstractPropertyEditor.this);
                }
            }
        });
    }

    protected void checkInput() {
        if (this.propertyPath != null && this.input != null) {
            this.isEditable = this.input.isEditable(this.propertyPath);
            try {
                this.doBinding();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            if (this.getInputObservable() instanceof ICommitListener && this.getEditor() != null) {
                this.getEditor().addCommitListener((ICommitListener)this.getInputObservable());
            }
            this.updateLabel();
            this.updateDescription();
        }
    }

    protected void doBinding() {
        IObservableValue inputObservableValue;
        if (this.listEditor != null) {
            IObservableList inputObservableList = this.getInputObservableList();
            if (inputObservableList != null) {
                this.listEditor.setModelObservable(inputObservableList);
            }
        } else if (this.valueEditor != null && (inputObservableValue = this.getInputObservableValue()) != null) {
            this.valueEditor.setStrategies();
            IValidator modelVal = this.getValidator();
            if (modelVal != null) {
                this.valueEditor.setModelValidator(modelVal);
            }
            this.valueEditor.setModelObservable(inputObservableValue);
        }
        boolean isReadOnly = this.getReadOnly();
        this.applyReadOnly(isReadOnly);
        if (this.input.forceRefresh(this.propertyPath)) {
            this.input.addChangeListener(this);
        }
    }

    protected void applyReadOnly(boolean readOnly) {
        AbstractEditor editor = this.getEditor();
        if (editor != null && !editor.isDisposed()) {
            editor.setReadOnly(readOnly);
        }
    }

    public void handleChange(ChangeEvent event) {
        AbstractEditor editor = this.getEditor();
        if (editor != null) {
            editor.refreshValue();
            this.isEditable = this.input.isEditable(this.propertyPath);
            this.applyReadOnly(this.getReadOnly());
        }
    }

    @Override
    public void setProperty(String path) {
        this.propertyPath = path;
        this.checkInput();
        this.updateLabel();
        this.updateDescription();
        this.manageObservableListeners();
    }

    public void updateLabel() {
        String label = this.getLabel();
        this.updateLabel(label);
    }

    public void updateLabel(String label) {
        if (this.showLabel) {
            if (this.valueEditor != null) {
                this.valueEditor.setLabel(label);
            } else if (this.listEditor != null) {
                this.listEditor.setLabel(label);
            }
        }
    }

    @Override
    public String getProperty() {
        return this.propertyPath;
    }

    @Override
    public void setInput(DataSource input) {
        DataSource oldInput = this.input;
        if (input != oldInput) {
            if (oldInput != null) {
                this.unhookDataSourceListener(oldInput);
            }
            this.input = input;
            if (input != null) {
                this.hookDataSourceListener(input);
            }
            this.checkInput();
            this.manageObservableListeners();
        }
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
    }

    protected void hookDataSourceListener(DataSource newInput) {
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    @Override
    public DataSource getInput() {
        return this.input;
    }

    protected String getLabel() {
        String label;
        ModelElement modelElement;
        if (this.customLabel != null) {
            return this.customLabel;
        }
        if (this.getInput() != null && (modelElement = this.getInput().getModelElement(this.propertyPath)) instanceof ILabeledModelElement && (label = ((ILabeledModelElement)((Object)modelElement)).getLabel(this.getLocalPropertyPath())) != null && !label.isEmpty()) {
            return label;
        }
        Property property = this.getModelProperty();
        if (property == null || property.getLabel() == null || property.getLabel().trim().equals("")) {
            return PropertiesUtil.getLabel(this.getLocalPropertyPath());
        }
        return property.getLabel();
    }

    protected void updateDescription() {
        String description = "";
        Property property = this.getModelProperty();
        if (property != null) {
            description = property.getDescription();
        }
        if (description == null || description.trim().equals("")) {
            description = this.getLocalPropertyPath();
        } else {
            description = PropertiesUtil.resizeString(description, descriptionMaxCharPerLine);
            description = String.valueOf(this.getLocalPropertyPath()) + ": " + description;
        }
        this.updateDescription(description);
    }

    protected void updateDescription(String description) {
        if (this.valueEditor != null) {
            this.valueEditor.setToolTipText(description);
        } else if (this.listEditor != null) {
            this.listEditor.setToolTipText(description);
        }
    }

    protected Property getModelProperty() {
        if (this.propertyPath == null) {
            return null;
        }
        Context context = this.getContext();
        return PropertiesRuntime.getConfigurationManager().getProperty(this.propertyPath, context);
    }

    private Context getContext() {
        if (this.input == null) {
            return null;
        }
        return this.input.getView().getContext();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (this.getEditor() != null) {
            this.getEditor().setReadOnly(this.getReadOnly());
        }
    }

    public AbstractEditor getEditor() {
        return this.valueEditor == null ? this.listEditor : this.valueEditor;
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly || !this.isEditable || this.getInputObservable() == null;
    }

    protected IObservableList getInputObservableList() {
        if (this.observableList == null) {
            try {
                this.observableList = (IObservableList)this.input.getObservable(this.propertyPath);
            }
            catch (Exception ex) {
                Activator.log.error("Cannot find a valid IObservableList for " + this.propertyPath, (Throwable)ex);
            }
        }
        return this.observableList;
    }

    protected IObservableValue getInputObservableValue() {
        if (this.observableValue == null) {
            try {
                this.observableValue = (IObservableValue)this.input.getObservable(this.propertyPath);
            }
            catch (Exception ex) {
                Activator.log.error("Cannot find a valid IObservableValue for " + this.propertyPath, (Throwable)ex);
            }
        }
        return this.observableValue;
    }

    protected IObservable getInputObservable() {
        if (this.input == null || this.propertyPath == null) {
            return null;
        }
        if (this.listEditor != null) {
            return this.getInputObservableList();
        }
        if (this.valueEditor != null) {
            return this.getInputObservableValue();
        }
        return null;
    }

    protected String getLocalPropertyPath() {
        return this.propertyPath.substring(this.propertyPath.lastIndexOf(":") + 1);
    }

    public void setLayoutData(Object data) {
        if (this.getEditor() != null) {
            this.getEditor().setLayoutData(data);
        }
    }

    public Object getLayoutData() {
        return this.getEditor() == null ? null : this.getEditor().getLayoutData();
    }

    public void setLayout(Layout layout) {
        if (this.getEditor() != null) {
            this.getEditor().setLayout(layout);
        }
    }

    public Layout getLayout() {
        return this.getEditor() == null ? null : this.getEditor().getLayout();
    }

    @Override
    public void setShowLabel(boolean showLabel) {
        AbstractEditor editor = this.getEditor();
        this.showLabel = showLabel;
        if (editor != null) {
            editor.setDisplayLabel(showLabel);
        }
    }

    @Override
    public boolean getShowLabel() {
        return this.showLabel;
    }

    @Override
    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
        this.updateLabel();
    }

    @Override
    public String getCustomLabel() {
        return this.customLabel;
    }

    public Control getControl() {
        if (this.valueEditor == null) {
            return this.listEditor;
        }
        return this.valueEditor;
    }

    public IValidator getValidator() {
        if (this.modelValidator == null) {
            try {
                this.modelValidator = this.input.getValidator(this.propertyPath);
            }
            catch (Exception ex) {
                Activator.log.error("Cannot find a valid Validator for " + this.propertyPath, (Throwable)ex);
            }
        }
        return this.modelValidator;
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                @Override
                public void dataSourceChanged(DataSourceChangedEvent event) {
                    IObservableValue observable = AbstractPropertyEditor.this.observableValue;
                    if (observable != null) {
                        if (AbstractPropertyEditor.this.modelValidator != null && AbstractPropertyEditor.this.valueEditor != null && !AbstractPropertyEditor.this.valueEditor.isDisposed()) {
                            AbstractPropertyEditor.this.modelValidator = null;
                            AbstractPropertyEditor.this.valueEditor.setStrategies();
                            AbstractPropertyEditor.this.valueEditor.setModelValidator(null);
                            observable.getRealm().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).AbstractPropertyEditor.this.valueEditor != null && !(this).AbstractPropertyEditor.this.valueEditor.isDisposed()) {
                                        (this).AbstractPropertyEditor.this.valueEditor.setStrategies();
                                        (this).AbstractPropertyEditor.this.valueEditor.setModelValidator(AbstractPropertyEditor.this.getValidator());
                                    }
                                }
                            });
                        }
                        if (AbstractPropertyEditor.this.propertyPath != null && AbstractPropertyEditor.this.input != null) {
                            observable.getRealm().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    (this).AbstractPropertyEditor.this.isEditable = (this).AbstractPropertyEditor.this.input.isEditable((this).AbstractPropertyEditor.this.propertyPath);
                                    AbstractPropertyEditor.this.applyReadOnly(AbstractPropertyEditor.this.getReadOnly());
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.dataSourceListener;
    }

    public String getListeningPropertyPaths() {
        return this.listeningPropertyPaths;
    }

    public String getListenerClasses() {
        return this.listenerClasses;
    }

    public void setListeningPropertyPaths(String listeningPropertyPaths) {
        this.listeningPropertyPaths = listeningPropertyPaths;
        if (listeningPropertyPaths.isEmpty()) {
            this.listeningPropertyPathsSet = null;
        } else {
            String[] propertyPaths = listeningPropertyPaths.trim().split(LIST_SEPARATOR);
            if (this.listeningPropertyPathsSet == null) {
                this.listeningPropertyPathsSet = new HashSet<String>();
            }
            int i = 0;
            while (i < propertyPaths.length) {
                if (!propertyPaths[i].isEmpty()) {
                    this.listeningPropertyPathsSet.add(propertyPaths[i]);
                }
                ++i;
            }
            this.manageObservableListeners();
        }
    }

    public void setListenerClasses(String listenerClasses) {
        this.listenerClasses = listenerClasses;
        if (listenerClasses.isEmpty()) {
            this.listenerClassesSet = null;
        } else {
            String[] propertyPaths = listenerClasses.trim().split(LIST_SEPARATOR);
            if (this.listenerClassesSet == null) {
                this.listenerClassesSet = new HashSet<IPropertiesListener>();
            }
            int i = 0;
            while (i < propertyPaths.length) {
                String listenerMethodPath = propertyPaths[i];
                if (!listenerMethodPath.isEmpty()) {
                    try {
                        Class listenerClass;
                        String[] splittedListenerMethodPath = listenerMethodPath.split(BUNDLE_SEPARATOR);
                        if (splittedListenerMethodPath.length > 1) {
                            Bundle bundle = Platform.getBundle((String)splittedListenerMethodPath[0]);
                            listenerClass = bundle.loadClass(splittedListenerMethodPath[1]);
                        } else {
                            listenerClass = Class.forName(listenerMethodPath);
                        }
                        List<Class<?>> interfacesImplemented = Arrays.asList(listenerClass.getInterfaces());
                        if (interfacesImplemented.contains(IPropertiesListener.class)) {
                            this.listenerClassesSet.add((IPropertiesListener)listenerClass.newInstance());
                        } else {
                            Activator.log.error("The listener classes defined in listenerClasses must implement 'IPropertiesListener' interface.", null);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Activator.log.error("The listener classes defined in listenerClasses are not correct.", (Throwable)e);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                ++i;
            }
            this.manageObservableListeners();
        }
    }

    public void manageObservableListeners() {
        String property = this.getProperty();
        DataSource input = this.getInput();
        if (property != null && !property.isEmpty() && input != null) {
            final Set<String> propertyPathsSet = this.listeningPropertyPathsSet;
            final Set<IPropertiesListener> classesSet = this.listenerClassesSet;
            if (propertyPathsSet != null && !propertyPathsSet.isEmpty() && classesSet != null && !classesSet.isEmpty()) {
                for (String listeningPropertyPath : propertyPathsSet) {
                    IObservable observable = input.getObservable(listeningPropertyPath);
                    if (observable == null) continue;
                    observable.addChangeListener(new IChangeListener(){

                        public void handleChange(ChangeEvent event) {
                            AbstractPropertyEditor.this.handlePropertiesListener(classesSet, propertyPathsSet);
                        }
                    });
                    this.handlePropertiesListener(classesSet, propertyPathsSet);
                }
            }
        }
    }

    private void handlePropertiesListener(Set<IPropertiesListener> classesSet, Set<String> propertyPathsSet) {
        for (IPropertiesListener iPropertiesListener : classesSet) {
            iPropertiesListener.handle(this, this.input, propertyPathsSet);
        }
    }
}

