/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.service;

import com.google.common.base.Function;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.sync.internal.SyncService;
import org.eclipse.papyrus.infra.sync.service.ISyncAction;
import org.eclipse.papyrus.infra.sync.service.ISyncService;

public class CascadeTriggers
implements ISyncAction {
    private final ISyncService service = SyncService.getCurrent();
    private Function<Object, ? extends Iterable<?>> cascadeFunction;

    public CascadeTriggers() {
        this(null);
    }

    public CascadeTriggers(Function<Object, ? extends Iterable<?>> cascadeFunction) {
        this.cascadeFunction = cascadeFunction;
    }

    public void setCascadeFunction(Function<Object, ? extends Iterable<?>> cascadeFunction) {
        this.cascadeFunction = cascadeFunction;
    }

    @Override
    public IStatus perform(ISyncService syncService, Object object) {
        IStatus result = Status.OK_STATUS;
        for (Object next : this.cascade(object)) {
            IStatus nextResult = this.service.evaluateTriggers(next);
            if (nextResult == null || nextResult.isOK()) continue;
            if (result.isOK()) {
                result = nextResult;
                continue;
            }
            if (result.isMultiStatus()) {
                ((MultiStatus)result).merge(nextResult);
                continue;
            }
            result = new MultiStatus("org.eclipse.papyrus.infra.sync", 0, new IStatus[]{result, nextResult}, "Multiple sync trigger cascade problems occurred.", null);
        }
        return result;
    }

    protected Iterable<?> cascade(Object triggered) {
        if (this.cascadeFunction == null) {
            throw new IllegalStateException("no cascade function");
        }
        return (Iterable)this.cascadeFunction.apply(triggered);
    }
}

