/**
 * Copyright (c) 2014 CEA LIST.
  *
  * All rights reserved. This program and the accompanying materials
  * are made available under the terms of the Eclipse Public License 2.0
  * which accompanies this distribution, and is available at
  * https://www.eclipse.org/legal/epl-2.0/
  *
  * SPDX-License-Identifier: EPL-2.0
  *
  * Contributors:
  *  CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.uml.diagram.composite.providers;

import org.eclipse.papyrus.uml.diagram.composite.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentSpecification;
import org.eclipse.uml2.uml.Device;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.ExecutionEnvironment;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeInterval;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * @generated
 */
public class ElementInitializers {

	protected ElementInitializers() {
		// use #getInstance to access cached instance
	}

	/**
	 * @generated
	 */
	public void init_Activity_Shape(Activity instance) {
		try {
			Object value_0 = name_Activity_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Interaction_Shape(Interaction instance) {
		try {
			Object value_0 = name_Interaction_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ProtocolStateMachine_Shape(ProtocolStateMachine instance) {
		try {
			Object value_0 = name_ProtocolStateMachine_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_StateMachine_Shape(StateMachine instance) {
		try {
			Object value_0 = name_StateMachine_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_FunctionBehavior_Shape(FunctionBehavior instance) {
		try {
			Object value_0 = name_FunctionBehavior_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_OpaqueBehavior_Shape(OpaqueBehavior instance) {
		try {
			Object value_0 = name_OpaqueBehavior_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Component_Shape(Component instance) {
		try {
			Object value_0 = name_Component_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Device_Shape(Device instance) {
		try {
			Object value_0 = name_Device_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ExecutionEnvironment_Shape(ExecutionEnvironment instance) {
		try {
			Object value_0 = name_ExecutionEnvironment_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Node_Shape(Node instance) {
		try {
			Object value_0 = name_Node_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Class_Shape(Class instance) {
		try {
			Object value_0 = name_Class_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Collaboration_Shape(Collaboration instance) {
		try {
			Object value_0 = name_Collaboration_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Interface_Shape(Interface instance) {
		try {
			Object value_0 = name_Interface_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_PrimitiveType_Shape(PrimitiveType instance) {
		try {
			Object value_0 = name_PrimitiveType_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Enumeration_Shape(Enumeration instance) {
		try {
			Object value_0 = name_Enumeration_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DataType_Shape(DataType instance) {
		try {
			Object value_0 = name_DataType_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Actor_Shape(Actor instance) {
		try {
			Object value_0 = name_Actor_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DeploymentSpecification_Shape(DeploymentSpecification instance) {
		try {
			Object value_0 = name_DeploymentSpecification_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Artifact_Shape(Artifact instance) {
		try {
			Object value_0 = name_Artifact_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InformationItem_Shape(InformationItem instance) {
		try {
			Object value_0 = name_InformationItem_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = isAbstract_InformationItem_Shape(instance);
			if (value_1 != null) {
				instance.setIsAbstract(
						((Boolean) value_1).booleanValue());
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Signal_Shape(Signal instance) {
		try {
			Object value_0 = name_Signal_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_UseCase_Shape(UseCase instance) {
		try {
			Object value_0 = name_UseCase_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_SignalEvent_Shape(SignalEvent instance) {
		try {
			Object value_0 = name_SignalEvent_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_CallEvent_Shape(CallEvent instance) {
		try {
			Object value_0 = name_CallEvent_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_AnyReceiveEvent_Shape(AnyReceiveEvent instance) {
		try {
			Object value_0 = name_AnyReceiveEvent_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ChangeEvent_Shape(ChangeEvent instance) {
		try {
			Object value_0 = name_ChangeEvent_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_TimeEvent_Shape(TimeEvent instance) {
		try {
			Object value_0 = name_TimeEvent_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DurationObservation_Shape(DurationObservation instance) {
		try {
			Object value_0 = name_DurationObservation_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_TimeObservation_Shape(TimeObservation instance) {
		try {
			Object value_0 = name_TimeObservation_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_LiteralBoolean_Shape(LiteralBoolean instance) {
		try {
			Object value_0 = name_LiteralBoolean_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_LiteralInteger_Shape(LiteralInteger instance) {
		try {
			Object value_0 = name_LiteralInteger_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_LiteralNull_Shape(LiteralNull instance) {
		try {
			Object value_0 = name_LiteralNull_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_LiteralString_Shape(LiteralString instance) {
		try {
			Object value_0 = name_LiteralString_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_LiteralUnlimitedNatural_Shape(LiteralUnlimitedNatural instance) {
		try {
			Object value_0 = name_LiteralUnlimitedNatural_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_StringExpression_PackagedElementShape(StringExpression instance) {
		try {
			Object value_0 = name_StringExpression_PackagedElementShape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_OpaqueExpression_Shape(OpaqueExpression instance) {
		try {
			Object value_0 = name_OpaqueExpression_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_TimeExpression_Shape(TimeExpression instance) {
		try {
			Object value_0 = name_TimeExpression_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Expression_Shape(Expression instance) {
		try {
			Object value_0 = name_Expression_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Duration_Shape(Duration instance) {
		try {
			Object value_0 = name_Duration_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_TimeInterval_Shape(TimeInterval instance) {
		try {
			Object value_0 = name_TimeInterval_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DurationInterval_Shape(DurationInterval instance) {
		try {
			Object value_0 = name_DurationInterval_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Interval_Shape(Interval instance) {
		try {
			Object value_0 = name_Interval_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InstanceValue_Shape(InstanceValue instance) {
		try {
			Object value_0 = name_InstanceValue_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Comment_Shape(Comment instance) {
		try {
			Object value_0 = body_Comment_Shape(instance);
			if (value_0 != null) {
				instance.setBody(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DurationConstraint_Shape(DurationConstraint instance) {
		try {
			Object value_0 = name_DurationConstraint_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_DurationConstraint_Shape(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_TimeConstraint_Shape(TimeConstraint instance) {
		try {
			Object value_0 = name_TimeConstraint_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_TimeConstraint_Shape(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_IntervalConstraint_Shape(IntervalConstraint instance) {
		try {
			Object value_0 = name_IntervalConstraint_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_IntervalConstraint_Shape(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InteractionConstraint_Shape(InteractionConstraint instance) {
		try {
			Object value_0 = name_InteractionConstraint_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_InteractionConstraint_Shape(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Constraint_Shape(Constraint instance) {
		try {
			Object value_0 = name_Constraint_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_Constraint_Shape(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Port_BehaviorShape(Port instance) {
		try {
			Object value_0 = name_Port_BehaviorShape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			instance.setAggregation(
					AggregationKind.COMPOSITE_LITERAL);

		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Port_Shape(Port instance) {
		try {
			Object value_0 = name_Port_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			instance.setAggregation(
					AggregationKind.COMPOSITE_LITERAL);

		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Parameter_Shape(Parameter instance) {
		try {
			Object value_0 = name_Parameter_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Property_Shape(Property instance) {
		try {
			Object value_0 = name_Property_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ConnectableElement_CollaborationRoleShape(ConnectableElement instance) {
		try {
			Object value_0 = name_ConnectableElement_CollaborationRoleShape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_CollaborationUse_Shape(CollaborationUse instance) {
		try {
			Object value_0 = name_CollaborationUse_Shape(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Activity_Shape_CN(Activity instance) {
		try {
			Object value_0 = name_Activity_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Interaction_Shape_CN(Interaction instance) {
		try {
			Object value_0 = name_Interaction_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ProtocolStateMachine_Shape_CN(ProtocolStateMachine instance) {
		try {
			Object value_0 = name_ProtocolStateMachine_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_StateMachine_Shape_CN(StateMachine instance) {
		try {
			Object value_0 = name_StateMachine_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_FunctionBehavior_Shape_CN(FunctionBehavior instance) {
		try {
			Object value_0 = name_FunctionBehavior_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_OpaqueBehavior_Shape_CN(OpaqueBehavior instance) {
		try {
			Object value_0 = name_OpaqueBehavior_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Component_Shape_CN(Component instance) {
		try {
			Object value_0 = name_Component_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Device_Shape_CN(Device instance) {
		try {
			Object value_0 = name_Device_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ExecutionEnvironment_Shape_CN(ExecutionEnvironment instance) {
		try {
			Object value_0 = name_ExecutionEnvironment_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Node_Shape_CN(Node instance) {
		try {
			Object value_0 = name_Node_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Class_Shape_CN(Class instance) {
		try {
			Object value_0 = name_Class_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Collaboration_Shape_CN(Collaboration instance) {
		try {
			Object value_0 = name_Collaboration_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Interface_Shape_CN(Interface instance) {
		try {
			Object value_0 = name_Interface_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_PrimitiveType_Shape_CN(PrimitiveType instance) {
		try {
			Object value_0 = name_PrimitiveType_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Enumeration_Shape_CN(Enumeration instance) {
		try {
			Object value_0 = name_Enumeration_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DataType_Shape_CN(DataType instance) {
		try {
			Object value_0 = name_DataType_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Actor_Shape_CN(Actor instance) {
		try {
			Object value_0 = name_Actor_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DeploymentSpecification_Shape_CN(DeploymentSpecification instance) {
		try {
			Object value_0 = name_DeploymentSpecification_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Artifact_Shape_CN(Artifact instance) {
		try {
			Object value_0 = name_Artifact_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InformationItem_Shape_CN(InformationItem instance) {
		try {
			Object value_0 = name_InformationItem_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = isAbstract_InformationItem_Shape_CN(instance);
			if (value_1 != null) {
				instance.setIsAbstract(
						((Boolean) value_1).booleanValue());
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Signal_Shape_CN(Signal instance) {
		try {
			Object value_0 = name_Signal_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_UseCase_Shape_CN(UseCase instance) {
		try {
			Object value_0 = name_UseCase_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Comment_Shape_CN(Comment instance) {
		try {
			Object value_0 = body_Comment_Shape_CN(instance);
			if (value_0 != null) {
				instance.setBody(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_DurationConstraint_Shape_CN(DurationConstraint instance) {
		try {
			Object value_0 = name_DurationConstraint_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_DurationConstraint_Shape_CN(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_TimeConstraint_Shape_CN(TimeConstraint instance) {
		try {
			Object value_0 = name_TimeConstraint_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_TimeConstraint_Shape_CN(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_IntervalConstraint_Shape_CN(IntervalConstraint instance) {
		try {
			Object value_0 = name_IntervalConstraint_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_IntervalConstraint_Shape_CN(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InteractionConstraint_Shape_CN(InteractionConstraint instance) {
		try {
			Object value_0 = name_InteractionConstraint_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_InteractionConstraint_Shape_CN(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Constraint_Shape_CN(Constraint instance) {
		try {
			Object value_0 = name_Constraint_Shape_CN(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
			Object value_1 = specification_Constraint_Shape_CN(instance);
			if (value_1 != null) {
				instance.setSpecification(
						(ValueSpecification) value_1);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Property_AttributeLabel(Property instance) {
		try {
			Object value_0 = name_Property_AttributeLabel(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Operation_OperationLabel(Operation instance) {
		try {
			Object value_0 = name_Operation_OperationLabel(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_EnumerationLiteral_LiteralLabel(EnumerationLiteral instance) {
		try {
			Object value_0 = name_EnumerationLiteral_LiteralLabel(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_ComponentRealization_Edge(ComponentRealization instance) {
		try {
			Object value_0 = name_ComponentRealization_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InterfaceRealization_Edge(InterfaceRealization instance) {
		try {
			Object value_0 = name_InterfaceRealization_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Substitution_Edge(Substitution instance) {
		try {
			Object value_0 = name_Substitution_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Realization_Edge(Realization instance) {
		try {
			Object value_0 = name_Realization_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Manifestation_Edge(Manifestation instance) {
		try {
			Object value_0 = name_Manifestation_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Abstraction_Edge(Abstraction instance) {
		try {
			Object value_0 = name_Abstraction_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Usage_Edge(Usage instance) {
		try {
			Object value_0 = name_Usage_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Deployment_Edge(Deployment instance) {
		try {
			Object value_0 = name_Deployment_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Dependency_Edge(Dependency instance) {
		try {
			Object value_0 = name_Dependency_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_Connector_Edge(Connector instance) {
		try {
			Object value_0 = name_Connector_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	public void init_InformationFlow_Edge(InformationFlow instance) {
		try {
			Object value_0 = name_InformationFlow_Edge(instance);
			if (value_0 != null) {
				instance.setName(
						(String) value_0);
			}
		} catch (RuntimeException e) {
			UMLDiagramEditorPlugin.getInstance().logError("Element initialization failed", e); //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String name_Activity_Shape(Activity it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Interaction_Shape(Interaction it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ProtocolStateMachine_Shape(ProtocolStateMachine it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_StateMachine_Shape(StateMachine it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_FunctionBehavior_Shape(FunctionBehavior it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_OpaqueBehavior_Shape(OpaqueBehavior it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Component_Shape(Component it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Device_Shape(Device it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ExecutionEnvironment_Shape(ExecutionEnvironment it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Node_Shape(Node it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Class_Shape(Class it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Collaboration_Shape(Collaboration it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Interface_Shape(Interface it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_PrimitiveType_Shape(PrimitiveType it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Enumeration_Shape(Enumeration it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_DataType_Shape(DataType it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Actor_Shape(Actor it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_DeploymentSpecification_Shape(DeploymentSpecification it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Artifact_Shape(Artifact it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_InformationItem_Shape(InformationItem it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private Boolean isAbstract_InformationItem_Shape(InformationItem it) {
		// InformationItem is Abstract
		return true;
	}

	/**
	 * @generated
	 */
	private String name_Signal_Shape(Signal it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_UseCase_Shape(UseCase it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_SignalEvent_Shape(SignalEvent it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_CallEvent_Shape(CallEvent it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_AnyReceiveEvent_Shape(AnyReceiveEvent it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ChangeEvent_Shape(ChangeEvent it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_TimeEvent_Shape(TimeEvent it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_DurationObservation_Shape(DurationObservation it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_TimeObservation_Shape(TimeObservation it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_LiteralBoolean_Shape(LiteralBoolean it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_LiteralInteger_Shape(LiteralInteger it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_LiteralNull_Shape(LiteralNull it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_LiteralString_Shape(LiteralString it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_LiteralUnlimitedNatural_Shape(LiteralUnlimitedNatural it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_StringExpression_PackagedElementShape(StringExpression it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_OpaqueExpression_Shape(OpaqueExpression it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_TimeExpression_Shape(TimeExpression it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Expression_Shape(Expression it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Duration_Shape(Duration it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_TimeInterval_Shape(TimeInterval it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_DurationInterval_Shape(DurationInterval it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Interval_Shape(Interval it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_InstanceValue_Shape(InstanceValue it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String body_Comment_Shape(Comment it) {
		// Comment body init
		return "";
	}

	/**
	 * @generated
	 */
	private String name_DurationConstraint_Shape(DurationConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_DurationConstraint_Shape(DurationConstraint it) {
		// DurationConstraint specification init
		DurationInterval value = UMLFactory.eINSTANCE.createDurationInterval();
		return value;
	}

	/**
	 * @generated
	 */
	private String name_TimeConstraint_Shape(TimeConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_TimeConstraint_Shape(TimeConstraint it) {
		// TimeConstraint specification init
		TimeInterval value = UMLFactory.eINSTANCE.createTimeInterval();
		return value;
	}

	/**
	 * @generated
	 */
	private String name_IntervalConstraint_Shape(IntervalConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_IntervalConstraint_Shape(IntervalConstraint it) {
		// IntervalConstraint specification init
		Interval value = UMLFactory.eINSTANCE.createInterval();
		return value;
	}

	/**
	 * @generated
	 */
	private String name_InteractionConstraint_Shape(InteractionConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_InteractionConstraint_Shape(InteractionConstraint it) {
		// Constraint specification init
		LiteralString value = UMLFactory.eINSTANCE.createLiteralString();
		value.setValue("");
		return value;
	}

	/**
	 * @generated
	 */
	private String name_Constraint_Shape(Constraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_Constraint_Shape(Constraint it) {
		// Constraint specification init
		LiteralString value = UMLFactory.eINSTANCE.createLiteralString();
		value.setValue("");
		return value;
	}

	/**
	 * @generated
	 */
	private String name_Port_BehaviorShape(Port it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Port_Shape(Port it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Parameter_Shape(Parameter it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Property_Shape(Property it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ConnectableElement_CollaborationRoleShape(ConnectableElement it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_CollaborationUse_Shape(CollaborationUse it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Activity_Shape_CN(Activity it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Interaction_Shape_CN(Interaction it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ProtocolStateMachine_Shape_CN(ProtocolStateMachine it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_StateMachine_Shape_CN(StateMachine it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_FunctionBehavior_Shape_CN(FunctionBehavior it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_OpaqueBehavior_Shape_CN(OpaqueBehavior it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Component_Shape_CN(Component it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Device_Shape_CN(Device it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ExecutionEnvironment_Shape_CN(ExecutionEnvironment it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Node_Shape_CN(Node it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Class_Shape_CN(Class it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Collaboration_Shape_CN(Collaboration it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Interface_Shape_CN(Interface it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_PrimitiveType_Shape_CN(PrimitiveType it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Enumeration_Shape_CN(Enumeration it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_DataType_Shape_CN(DataType it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Actor_Shape_CN(Actor it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_DeploymentSpecification_Shape_CN(DeploymentSpecification it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Artifact_Shape_CN(Artifact it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_InformationItem_Shape_CN(InformationItem it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private Boolean isAbstract_InformationItem_Shape_CN(InformationItem it) {
		// InformationItem is Abstract
		return true;
	}

	/**
	 * @generated
	 */
	private String name_Signal_Shape_CN(Signal it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_UseCase_Shape_CN(UseCase it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String body_Comment_Shape_CN(Comment it) {
		// Comment body init
		return "";
	}

	/**
	 * @generated
	 */
	private String name_DurationConstraint_Shape_CN(DurationConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_DurationConstraint_Shape_CN(DurationConstraint it) {
		// DurationConstraint specification init
		DurationInterval value = UMLFactory.eINSTANCE.createDurationInterval();
		return value;
	}

	/**
	 * @generated
	 */
	private String name_TimeConstraint_Shape_CN(TimeConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_TimeConstraint_Shape_CN(TimeConstraint it) {
		// TimeConstraint specification init
		TimeInterval value = UMLFactory.eINSTANCE.createTimeInterval();
		return value;
	}

	/**
	 * @generated
	 */
	private String name_IntervalConstraint_Shape_CN(IntervalConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_IntervalConstraint_Shape_CN(IntervalConstraint it) {
		// IntervalConstraint specification init
		Interval value = UMLFactory.eINSTANCE.createInterval();
		return value;
	}

	/**
	 * @generated
	 */
	private String name_InteractionConstraint_Shape_CN(InteractionConstraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_InteractionConstraint_Shape_CN(InteractionConstraint it) {
		// Constraint specification init
		LiteralString value = UMLFactory.eINSTANCE.createLiteralString();
		value.setValue("");
		return value;
	}

	/**
	 * @generated
	 */
	private String name_Constraint_Shape_CN(Constraint it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private ValueSpecification specification_Constraint_Shape_CN(Constraint it) {
		// Constraint specification init
		LiteralString value = UMLFactory.eINSTANCE.createLiteralString();
		value.setValue("");
		return value;
	}

	/**
	 * @generated
	 */
	private String name_Property_AttributeLabel(Property it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Operation_OperationLabel(Operation it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_EnumerationLiteral_LiteralLabel(EnumerationLiteral it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_ComponentRealization_Edge(ComponentRealization it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_InterfaceRealization_Edge(InterfaceRealization it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Substitution_Edge(Substitution it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Realization_Edge(Realization it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Manifestation_Edge(Manifestation it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Abstraction_Edge(Abstraction it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Usage_Edge(Usage it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Deployment_Edge(Deployment it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Dependency_Edge(Dependency it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_Connector_Edge(Connector it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	private String name_InformationFlow_Edge(InformationFlow it) {
		return NamedElementUtil.getDefaultNameWithIncrement(it, it.getOwner().eContents());
	}

	/**
	 * @generated
	 */
	public static ElementInitializers getInstance() {
		ElementInitializers cached = UMLDiagramEditorPlugin.getInstance().getElementInitializers();
		if (cached == null) {
			UMLDiagramEditorPlugin.getInstance().setElementInitializers(cached = new ElementInitializers());
		}
		return cached;
	}
}
