/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityXTextParserUtils {
    private static final String UNLIMITED_KEYWORD = "*";
    private static final String QUOTE = "\"";

    public static ICommand updateOneMultiplicityCommand(IElementEditService provider, EObject eObject, String bound) {
        CompositeCommand updateUpper;
        CompositeCommand updateLower;
        CompositeCommand compositeCommand = new CompositeCommand("Multiplicity update");
        if (UNLIMITED_KEYWORD.equals(bound)) {
            updateLower = MultiplicityXTextParserUtils.updateLowerValueSpecificationMultiplicityCommand(provider, eObject, "0");
            updateUpper = MultiplicityXTextParserUtils.updateUpperValueSpecificationMultiplicityCommand(provider, eObject, "-1");
        } else {
            updateLower = MultiplicityXTextParserUtils.updateLowerValueSpecificationMultiplicityCommand(provider, eObject, bound);
            updateUpper = MultiplicityXTextParserUtils.updateUpperValueSpecificationMultiplicityCommand(provider, eObject, bound);
        }
        if (!updateLower.isEmpty()) {
            compositeCommand.add((IUndoableOperation)updateLower);
        }
        if (!updateUpper.isEmpty()) {
            compositeCommand.add((IUndoableOperation)updateUpper);
        }
        if (compositeCommand.isEmpty()) {
            return null;
        }
        return compositeCommand.reduce();
    }

    public static ICommand updateTwoMultiplicityCommand(IElementEditService provider, EObject eObject, String lowerBound, String upperBound) {
        String upperBoundVal;
        CompositeCommand updateUpper;
        CompositeCommand compositeCommand = new CompositeCommand("Multiplicity update");
        CompositeCommand updateLower = MultiplicityXTextParserUtils.updateLowerValueSpecificationMultiplicityCommand(provider, eObject, lowerBound);
        if (!updateLower.isEmpty()) {
            compositeCommand.add((IUndoableOperation)updateLower);
        }
        if (!(updateUpper = MultiplicityXTextParserUtils.updateUpperValueSpecificationMultiplicityCommand(provider, eObject, upperBoundVal = UNLIMITED_KEYWORD.equals(upperBound) ? "-1" : upperBound)).isEmpty()) {
            compositeCommand.add((IUndoableOperation)updateUpper);
        }
        if (compositeCommand.isEmpty()) {
            return null;
        }
        return compositeCommand.reduce();
    }

    private static CompositeCommand updateLowerValueSpecificationMultiplicityCommand(IElementEditService provider, EObject eObject, String bound) {
        CompositeCommand compositeCommand = new CompositeCommand("Lower Multiplicity update");
        ValueSpecification newLowerValueSpecification = (ValueSpecification)eObject.eGet((EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue());
        try {
            int newBound = Integer.parseInt(bound);
            if (newLowerValueSpecification instanceof LiteralInteger) {
                if (newBound != ((LiteralInteger)newLowerValueSpecification).getValue()) {
                    compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, (EObject)newLowerValueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_INTEGER__VALUE, newBound));
                    compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), null));
                    compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), newLowerValueSpecification));
                }
            } else {
                newLowerValueSpecification = UMLFactory.eINSTANCE.createLiteralInteger();
                ((LiteralInteger)newLowerValueSpecification).setValue(newBound);
                compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), newLowerValueSpecification));
            }
        }
        catch (NumberFormatException e) {
            compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.updateLiteralStringMultiplicityCommand(provider, eObject, newLowerValueSpecification, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), bound));
        }
        return compositeCommand;
    }

    private static CompositeCommand updateUpperValueSpecificationMultiplicityCommand(IElementEditService provider, EObject eObject, String bound) {
        CompositeCommand compositeCommand = new CompositeCommand("Upper Multiplicity update");
        ValueSpecification newUpperValueSpecification = (ValueSpecification)eObject.eGet((EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue());
        try {
            int newBound = Integer.parseInt(bound);
            if (newUpperValueSpecification instanceof LiteralUnlimitedNatural) {
                if (newBound != ((LiteralUnlimitedNatural)newUpperValueSpecification).getValue()) {
                    compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, (EObject)newUpperValueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE, newBound));
                    compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), null));
                    compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), newUpperValueSpecification));
                }
            } else {
                newUpperValueSpecification = UMLFactory.eINSTANCE.createLiteralUnlimitedNatural();
                ((LiteralUnlimitedNatural)newUpperValueSpecification).setValue(newBound);
                compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), newUpperValueSpecification));
            }
        }
        catch (NumberFormatException e) {
            compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.updateLiteralStringMultiplicityCommand(provider, eObject, newUpperValueSpecification, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), bound));
        }
        return compositeCommand;
    }

    private static ICommand updateLiteralStringMultiplicityCommand(IElementEditService provider, EObject eObject, ValueSpecification initialValueSpecification, EStructuralFeature feature, String bound) {
        CompositeCommand compositeCommand = new CompositeCommand("String Multiplicity update");
        ValueSpecification newValueSpecification = initialValueSpecification;
        String newStringValue = null;
        newStringValue = bound.startsWith(QUOTE) && bound.endsWith(QUOTE) ? bound.substring(1, bound.length() - 1) : bound;
        if (newValueSpecification instanceof LiteralString) {
            if (!newStringValue.equals(((LiteralString)newValueSpecification).getValue())) {
                compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, (EObject)newValueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_STRING__VALUE, newStringValue));
                compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, feature, null));
                compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, feature, newValueSpecification));
            }
        } else {
            newValueSpecification = UMLFactory.eINSTANCE.createLiteralString();
            ((LiteralString)newValueSpecification).setValue(newStringValue);
            compositeCommand.add((IUndoableOperation)MultiplicityXTextParserUtils.createSetCommand(provider, eObject, feature, newValueSpecification));
        }
        return compositeCommand;
    }

    private static ICommand createSetCommand(IElementEditService provider, EObject parent, EStructuralFeature feature, Object value) {
        SetRequest setBoundRequest = new SetRequest(parent, feature, value);
        return provider.getEditCommand((IEditCommandRequest)setBoundRequest);
    }
}

