/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;

public class ArchitectureExtensionsChecker
implements IPluginChecker {
    private final IProject project;
    private final IFile architectureFile;

    public ArchitectureExtensionsChecker(IProject project, IFile architectureFile) {
        this.project = project;
        this.architectureFile = architectureFile;
    }

    public void check(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Validate 'plugin.xml' file for architecture '" + this.architectureFile.getName() + "'.");
        }
        boolean foundExtension = false;
        Iterator extensions = ProjectManagementService.getPluginExtensions((IProject)this.project).iterator();
        while (extensions.hasNext() && !foundExtension) {
            IPluginExtension extension = (IPluginExtension)extensions.next();
            if (!"org.eclipse.papyrus.infra.architecture.models".equals(extension.getPoint())) continue;
            IPluginObject[] iPluginObjectArray = extension.getChildren();
            int n = iPluginObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginObject pluginObject = iPluginObjectArray[n2];
                if (pluginObject instanceof IPluginElement && "model".equals(pluginObject.getName())) {
                    IPluginAttribute[] iPluginAttributeArray = ((IPluginElement)pluginObject).getAttributes();
                    int n3 = iPluginAttributeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginAttribute pluginAtttribute = iPluginAttributeArray[n4];
                        if ("path".equals(pluginAtttribute.getName())) {
                            String locationValue = pluginAtttribute.getValue();
                            foundExtension = locationValue.endsWith(this.architectureFile.getName());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (!foundExtension) {
            IFile pluginXMLFile = ProjectManagementService.getPluginXMLFile((IContainer)this.project);
            MarkersService.createMarker((IResource)pluginXMLFile, (String)"org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", (String)("The extension point 'org.eclipse.papyrus.infra.architecture.models' should be created for profile '" + this.architectureFile.getName() + "'"), (int)2);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

