/*******************************************************************************
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, ARTAL
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *     Borland - initial API and implementation
 *     Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 ******************************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.gmf.codegen.gmfgen.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.util.GMFGenAdapterFactory;
import org.eclipse.papyrus.gmf.codegen.gmfgen.presentation.EditorPlugin;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GMFGenItemProviderAdapterFactory extends GMFGenAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(EditorPlugin.INSTANCE, GMFGenPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GMFGenItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenEditorGeneratorItemProvider genEditorGeneratorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenEditorGeneratorAdapter() {
		if (genEditorGeneratorItemProvider == null) {
			genEditorGeneratorItemProvider = new GenEditorGeneratorItemProvider(this);
		}

		return genEditorGeneratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDiagramItemProvider genDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenDiagramAdapter() {
		if (genDiagramItemProvider == null) {
			genDiagramItemProvider = new GenDiagramItemProvider(this);
		}

		return genDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenEditorViewItemProvider genEditorViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenEditorViewAdapter() {
		if (genEditorViewItemProvider == null) {
			genEditorViewItemProvider = new GenEditorViewItemProvider(this);
		}

		return genEditorViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPreferencePage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCustomPreferencePageItemProvider genCustomPreferencePageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPreferencePage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCustomPreferencePageAdapter() {
		if (genCustomPreferencePageItemProvider == null) {
			genCustomPreferencePageItemProvider = new GenCustomPreferencePageItemProvider(this);
		}

		return genCustomPreferencePageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPreferencePage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenStandardPreferencePageItemProvider genStandardPreferencePageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPreferencePage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenStandardPreferencePageAdapter() {
		if (genStandardPreferencePageItemProvider == null) {
			genStandardPreferencePageItemProvider = new GenStandardPreferencePageItemProvider(this);
		}

		return genStandardPreferencePageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramPreferences} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDiagramPreferencesItemProvider genDiagramPreferencesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramPreferences}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenDiagramPreferencesAdapter() {
		if (genDiagramPreferencesItemProvider == null) {
			genDiagramPreferencesItemProvider = new GenDiagramPreferencesItemProvider(this);
		}

		return genDiagramPreferencesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardFont} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenStandardFontItemProvider genStandardFontItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardFont}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenStandardFontAdapter() {
		if (genStandardFontItemProvider == null) {
			genStandardFontItemProvider = new GenStandardFontItemProvider(this);
		}

		return genStandardFontItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomFont} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCustomFontItemProvider genCustomFontItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomFont}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCustomFontAdapter() {
		if (genCustomFontItemProvider == null) {
			genCustomFontItemProvider = new GenCustomFontItemProvider(this);
		}

		return genCustomFontItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenRGBColor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenRGBColorItemProvider genRGBColorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenRGBColor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenRGBColorAdapter() {
		if (genRGBColorItemProvider == null) {
			genRGBColorItemProvider = new GenRGBColorItemProvider(this);
		}

		return genRGBColorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstantColor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenConstantColorItemProvider genConstantColorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstantColor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenConstantColorAdapter() {
		if (genConstantColorItemProvider == null) {
			genConstantColorItemProvider = new GenConstantColorItemProvider(this);
		}

		return genConstantColorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenPreference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenPreferenceItemProvider genPreferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenPreference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenPreferenceAdapter() {
		if (genPreferenceItemProvider == null) {
			genPreferenceItemProvider = new GenPreferenceItemProvider(this);
		}

		return genPreferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramUpdater} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDiagramUpdaterItemProvider genDiagramUpdaterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramUpdater}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenDiagramUpdaterAdapter() {
		if (genDiagramUpdaterItemProvider == null) {
			genDiagramUpdaterItemProvider = new GenDiagramUpdaterItemProvider(this);
		}

		return genDiagramUpdaterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenPluginItemProvider genPluginItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenPluginAdapter() {
		if (genPluginItemProvider == null) {
			genPluginItemProvider = new GenPluginItemProvider(this);
		}

		return genPluginItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.DynamicModelAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DynamicModelAccessItemProvider dynamicModelAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.DynamicModelAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDynamicModelAccessAdapter() {
		if (dynamicModelAccessItemProvider == null) {
			dynamicModelAccessItemProvider = new DynamicModelAccessItemProvider(this);
		}

		return dynamicModelAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CustomBehaviour} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomBehaviourItemProvider customBehaviourItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CustomBehaviour}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomBehaviourAdapter() {
		if (customBehaviourItemProvider == null) {
			customBehaviourItemProvider = new CustomBehaviourItemProvider(this);
		}

		return customBehaviourItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.SharedBehaviour} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SharedBehaviourItemProvider sharedBehaviourItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.SharedBehaviour}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSharedBehaviourAdapter() {
		if (sharedBehaviourItemProvider == null) {
			sharedBehaviourItemProvider = new SharedBehaviourItemProvider(this);
		}

		return sharedBehaviourItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.OpenDiagramBehaviour} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OpenDiagramBehaviourItemProvider openDiagramBehaviourItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.OpenDiagramBehaviour}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOpenDiagramBehaviourAdapter() {
		if (openDiagramBehaviourItemProvider == null) {
			openDiagramBehaviourItemProvider = new OpenDiagramBehaviourItemProvider(this);
		}

		return openDiagramBehaviourItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenTopLevelNodeItemProvider genTopLevelNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenTopLevelNodeAdapter() {
		if (genTopLevelNodeItemProvider == null) {
			genTopLevelNodeItemProvider = new GenTopLevelNodeItemProvider(this);
		}

		return genTopLevelNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenChildNodeItemProvider genChildNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenChildNodeAdapter() {
		if (genChildNodeItemProvider == null) {
			genChildNodeItemProvider = new GenChildNodeItemProvider(this);
		}

		return genChildNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenChildSideAffixedNodeItemProvider genChildSideAffixedNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenChildSideAffixedNodeAdapter() {
		if (genChildSideAffixedNodeItemProvider == null) {
			genChildSideAffixedNodeItemProvider = new GenChildSideAffixedNodeItemProvider(this);
		}

		return genChildSideAffixedNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenChildLabelNodeItemProvider genChildLabelNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenChildLabelNodeAdapter() {
		if (genChildLabelNodeItemProvider == null) {
			genChildLabelNodeItemProvider = new GenChildLabelNodeItemProvider(this);
		}

		return genChildLabelNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCompartmentItemProvider genCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCompartmentAdapter() {
		if (genCompartmentItemProvider == null) {
			genCompartmentItemProvider = new GenCompartmentItemProvider(this);
		}

		return genCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLinkItemProvider genLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenLinkAdapter() {
		if (genLinkItemProvider == null) {
			genLinkItemProvider = new GenLinkItemProvider(this);
		}

		return genLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNodeLabelItemProvider genNodeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNodeLabelAdapter() {
		if (genNodeLabelItemProvider == null) {
			genNodeLabelItemProvider = new GenNodeLabelItemProvider(this);
		}

		return genNodeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenExternalNodeLabelItemProvider genExternalNodeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenExternalNodeLabelAdapter() {
		if (genExternalNodeLabelItemProvider == null) {
			genExternalNodeLabelItemProvider = new GenExternalNodeLabelItemProvider(this);
		}

		return genExternalNodeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLinkLabelItemProvider genLinkLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenLinkLabelAdapter() {
		if (genLinkLabelItemProvider == null) {
			genLinkLabelItemProvider = new GenLinkLabelItemProvider(this);
		}

		return genLinkLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.MetamodelType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetamodelTypeItemProvider metamodelTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.MetamodelType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetamodelTypeAdapter() {
		if (metamodelTypeItemProvider == null) {
			metamodelTypeItemProvider = new MetamodelTypeItemProvider(this);
		}

		return metamodelTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.SpecializationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpecializationTypeItemProvider specializationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.SpecializationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpecializationTypeAdapter() {
		if (specializationTypeItemProvider == null) {
			specializationTypeItemProvider = new SpecializationTypeItemProvider(this);
		}

		return specializationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.NotationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotationTypeItemProvider notationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.NotationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNotationTypeAdapter() {
		if (notationTypeItemProvider == null) {
			notationTypeItemProvider = new NotationTypeItemProvider(this);
		}

		return notationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelModelFacetItemProvider labelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelModelFacetAdapter() {
		if (labelModelFacetItemProvider == null) {
			labelModelFacetItemProvider = new LabelModelFacetItemProvider(this);
		}

		return labelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeModelFacetItemProvider typeModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeModelFacetAdapter() {
		if (typeModelFacetItemProvider == null) {
			typeModelFacetItemProvider = new TypeModelFacetItemProvider(this);
		}

		return typeModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeLinkModelFacetItemProvider typeLinkModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeLinkModelFacetAdapter() {
		if (typeLinkModelFacetItemProvider == null) {
			typeLinkModelFacetItemProvider = new TypeLinkModelFacetItemProvider(this);
		}

		return typeLinkModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureLinkModelFacetItemProvider featureLinkModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureLinkModelFacetAdapter() {
		if (featureLinkModelFacetItemProvider == null) {
			featureLinkModelFacetItemProvider = new FeatureLinkModelFacetItemProvider(this);
		}

		return featureLinkModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureLabelModelFacetItemProvider featureLabelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureLabelModelFacetAdapter() {
		if (featureLabelModelFacetItemProvider == null) {
			featureLabelModelFacetItemProvider = new FeatureLabelModelFacetItemProvider(this);
		}

		return featureLabelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DesignLabelModelFacetItemProvider designLabelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDesignLabelModelFacetAdapter() {
		if (designLabelModelFacetItemProvider == null) {
			designLabelModelFacetItemProvider = new DesignLabelModelFacetItemProvider(this);
		}

		return designLabelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionLabelModelFacetItemProvider expressionLabelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionLabelModelFacetAdapter() {
		if (expressionLabelModelFacetItemProvider == null) {
			expressionLabelModelFacetItemProvider = new ExpressionLabelModelFacetItemProvider(this);
		}

		return expressionLabelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ColorAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ColorAttributesItemProvider colorAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ColorAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createColorAttributesAdapter() {
		if (colorAttributesItemProvider == null) {
			colorAttributesItemProvider = new ColorAttributesItemProvider(this);
		}

		return colorAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.StyleAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StyleAttributesItemProvider styleAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.StyleAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStyleAttributesAdapter() {
		if (styleAttributesItemProvider == null) {
			styleAttributesItemProvider = new StyleAttributesItemProvider(this);
		}

		return styleAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ResizeConstraints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResizeConstraintsItemProvider resizeConstraintsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ResizeConstraints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResizeConstraintsAdapter() {
		if (resizeConstraintsItemProvider == null) {
			resizeConstraintsItemProvider = new ResizeConstraintsItemProvider(this);
		}

		return resizeConstraintsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.DefaultSizeAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultSizeAttributesItemProvider defaultSizeAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.DefaultSizeAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultSizeAttributesAdapter() {
		if (defaultSizeAttributesItemProvider == null) {
			defaultSizeAttributesItemProvider = new DefaultSizeAttributesItemProvider(this);
		}

		return defaultSizeAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.LabelOffsetAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelOffsetAttributesItemProvider labelOffsetAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.LabelOffsetAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelOffsetAttributesAdapter() {
		if (labelOffsetAttributesItemProvider == null) {
			labelOffsetAttributesItemProvider = new LabelOffsetAttributesItemProvider(this);
		}

		return labelOffsetAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FigureViewmapItemProvider figureViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFigureViewmapAdapter() {
		if (figureViewmapItemProvider == null) {
			figureViewmapItemProvider = new FigureViewmapItemProvider(this);
		}

		return figureViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SnippetViewmapItemProvider snippetViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSnippetViewmapAdapter() {
		if (snippetViewmapItemProvider == null) {
			snippetViewmapItemProvider = new SnippetViewmapItemProvider(this);
		}

		return snippetViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InnerClassViewmapItemProvider innerClassViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInnerClassViewmapAdapter() {
		if (innerClassViewmapItemProvider == null) {
			innerClassViewmapItemProvider = new InnerClassViewmapItemProvider(this);
		}

		return innerClassViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParentAssignedViewmapItemProvider parentAssignedViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParentAssignedViewmapAdapter() {
		if (parentAssignedViewmapItemProvider == null) {
			parentAssignedViewmapItemProvider = new ParentAssignedViewmapItemProvider(this);
		}

		return parentAssignedViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeledViewmapItemProvider modeledViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeledViewmapAdapter() {
		if (modeledViewmapItemProvider == null) {
			modeledViewmapItemProvider = new ModeledViewmapItemProvider(this);
		}

		return modeledViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.Palette} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PaletteItemProvider paletteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.Palette}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPaletteAdapter() {
		if (paletteItemProvider == null) {
			paletteItemProvider = new PaletteItemProvider(this);
		}

		return paletteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolEntryItemProvider toolEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createToolEntryAdapter() {
		if (toolEntryItemProvider == null) {
			toolEntryItemProvider = new ToolEntryItemProvider(this);
		}

		return toolEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StandardEntryItemProvider standardEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStandardEntryAdapter() {
		if (standardEntryItemProvider == null) {
			standardEntryItemProvider = new StandardEntryItemProvider(this);
		}

		return standardEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.Separator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SeparatorItemProvider separatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.Separator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSeparatorAdapter() {
		if (separatorItemProvider == null) {
			separatorItemProvider = new SeparatorItemProvider(this);
		}

		return separatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolGroupItemProvider toolGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createToolGroupAdapter() {
		if (toolGroupItemProvider == null) {
			toolGroupItemProvider = new ToolGroupItemProvider(this);
		}

		return toolGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureSeqInitializer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenFeatureSeqInitializerItemProvider genFeatureSeqInitializerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureSeqInitializer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenFeatureSeqInitializerAdapter() {
		if (genFeatureSeqInitializerItemProvider == null) {
			genFeatureSeqInitializerItemProvider = new GenFeatureSeqInitializerItemProvider(this);
		}

		return genFeatureSeqInitializerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureValueSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenFeatureValueSpecItemProvider genFeatureValueSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureValueSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenFeatureValueSpecAdapter() {
		if (genFeatureValueSpecItemProvider == null) {
			genFeatureValueSpecItemProvider = new GenFeatureValueSpecItemProvider(this);
		}

		return genFeatureValueSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenReferenceNewElementSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenReferenceNewElementSpecItemProvider genReferenceNewElementSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenReferenceNewElementSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenReferenceNewElementSpecAdapter() {
		if (genReferenceNewElementSpecItemProvider == null) {
			genReferenceNewElementSpecItemProvider = new GenReferenceNewElementSpecItemProvider(this);
		}

		return genReferenceNewElementSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkConstraints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLinkConstraintsItemProvider genLinkConstraintsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkConstraints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenLinkConstraintsAdapter() {
		if (genLinkConstraintsItemProvider == null) {
			genLinkConstraintsItemProvider = new GenLinkConstraintsItemProvider(this);
		}

		return genLinkConstraintsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditRootItemProvider genAuditRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenAuditRootAdapter() {
		if (genAuditRootItemProvider == null) {
			genAuditRootItemProvider = new GenAuditRootItemProvider(this);
		}

		return genAuditRootItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditContainerItemProvider genAuditContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenAuditContainerAdapter() {
		if (genAuditContainerItemProvider == null) {
			genAuditContainerItemProvider = new GenAuditContainerItemProvider(this);
		}

		return genAuditContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditRuleItemProvider genAuditRuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenAuditRuleAdapter() {
		if (genAuditRuleItemProvider == null) {
			genAuditRuleItemProvider = new GenAuditRuleItemProvider(this);
		}

		return genAuditRuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainElementTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDomainElementTargetItemProvider genDomainElementTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainElementTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenDomainElementTargetAdapter() {
		if (genDomainElementTargetItemProvider == null) {
			genDomainElementTargetItemProvider = new GenDomainElementTargetItemProvider(this);
		}

		return genDomainElementTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDiagramElementTargetItemProvider genDiagramElementTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenDiagramElementTargetAdapter() {
		if (genDiagramElementTargetItemProvider == null) {
			genDiagramElementTargetItemProvider = new GenDiagramElementTargetItemProvider(this);
		}

		return genDiagramElementTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainAttributeTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDomainAttributeTargetItemProvider genDomainAttributeTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainAttributeTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenDomainAttributeTargetAdapter() {
		if (genDomainAttributeTargetItemProvider == null) {
			genDomainAttributeTargetItemProvider = new GenDomainAttributeTargetItemProvider(this);
		}

		return genDomainAttributeTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNotationElementTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNotationElementTargetItemProvider genNotationElementTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNotationElementTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNotationElementTargetAdapter() {
		if (genNotationElementTargetItemProvider == null) {
			genNotationElementTargetItemProvider = new GenNotationElementTargetItemProvider(this);
		}

		return genNotationElementTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenMetricContainerItemProvider genMetricContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenMetricContainerAdapter() {
		if (genMetricContainerItemProvider == null) {
			genMetricContainerItemProvider = new GenMetricContainerItemProvider(this);
		}

		return genMetricContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenMetricRuleItemProvider genMetricRuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenMetricRuleAdapter() {
		if (genMetricRuleItemProvider == null) {
			genMetricRuleItemProvider = new GenMetricRuleItemProvider(this);
		}

		return genMetricRuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditedMetricTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditedMetricTargetItemProvider genAuditedMetricTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditedMetricTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenAuditedMetricTargetAdapter() {
		if (genAuditedMetricTargetItemProvider == null) {
			genAuditedMetricTargetItemProvider = new GenAuditedMetricTargetItemProvider(this);
		}

		return genAuditedMetricTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContext} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditContextItemProvider genAuditContextItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContext}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenAuditContextAdapter() {
		if (genAuditContextItemProvider == null) {
			genAuditContextItemProvider = new GenAuditContextItemProvider(this);
		}

		return genAuditContextItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenExpressionProviderContainerItemProvider genExpressionProviderContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenExpressionProviderContainerAdapter() {
		if (genExpressionProviderContainerItemProvider == null) {
			genExpressionProviderContainerItemProvider = new GenExpressionProviderContainerItemProvider(this);
		}

		return genExpressionProviderContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenJavaExpressionProviderItemProvider genJavaExpressionProviderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenJavaExpressionProviderAdapter() {
		if (genJavaExpressionProviderItemProvider == null) {
			genJavaExpressionProviderItemProvider = new GenJavaExpressionProviderItemProvider(this);
		}

		return genJavaExpressionProviderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenExpressionInterpreterItemProvider genExpressionInterpreterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenExpressionInterpreterAdapter() {
		if (genExpressionInterpreterItemProvider == null) {
			genExpressionInterpreterItemProvider = new GenExpressionInterpreterItemProvider(this);
		}

		return genExpressionInterpreterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLiteralExpressionProvider} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLiteralExpressionProviderItemProvider genLiteralExpressionProviderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenLiteralExpressionProvider}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenLiteralExpressionProviderAdapter() {
		if (genLiteralExpressionProviderItemProvider == null) {
			genLiteralExpressionProviderItemProvider = new GenLiteralExpressionProviderItemProvider(this);
		}

		return genLiteralExpressionProviderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNavigatorItemProvider genNavigatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNavigatorAdapter() {
		if (genNavigatorItemProvider == null) {
			genNavigatorItemProvider = new GenNavigatorItemProvider(this);
		}

		return genNavigatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNavigatorChildReferenceItemProvider genNavigatorChildReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNavigatorChildReferenceAdapter() {
		if (genNavigatorChildReferenceItemProvider == null) {
			genNavigatorChildReferenceItemProvider = new GenNavigatorChildReferenceItemProvider(this);
		}

		return genNavigatorChildReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNavigatorPathItemProvider genNavigatorPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNavigatorPathAdapter() {
		if (genNavigatorPathItemProvider == null) {
			genNavigatorPathItemProvider = new GenNavigatorPathItemProvider(this);
		}

		return genNavigatorPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorPathSegment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNavigatorPathSegmentItemProvider genNavigatorPathSegmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorPathSegment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenNavigatorPathSegmentAdapter() {
		if (genNavigatorPathSegmentItemProvider == null) {
			genNavigatorPathSegmentItemProvider = new GenNavigatorPathSegmentItemProvider(this);
		}

		return genNavigatorPathSegmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenPropertySheetItemProvider genPropertySheetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenPropertySheetAdapter() {
		if (genPropertySheetItemProvider == null) {
			genPropertySheetItemProvider = new GenPropertySheetItemProvider(this);
		}

		return genPropertySheetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPropertyTab} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenStandardPropertyTabItemProvider genStandardPropertyTabItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenStandardPropertyTab}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenStandardPropertyTabAdapter() {
		if (genStandardPropertyTabItemProvider == null) {
			genStandardPropertyTabItemProvider = new GenStandardPropertyTabItemProvider(this);
		}

		return genStandardPropertyTabItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPropertyTab} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCustomPropertyTabItemProvider genCustomPropertyTabItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPropertyTab}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCustomPropertyTabAdapter() {
		if (genCustomPropertyTabItemProvider == null) {
			genCustomPropertyTabItemProvider = new GenCustomPropertyTabItemProvider(this);
		}

		return genCustomPropertyTabItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.TypeTabFilter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeTabFilterItemProvider typeTabFilterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.TypeTabFilter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeTabFilterAdapter() {
		if (typeTabFilterItemProvider == null) {
			typeTabFilterItemProvider = new TypeTabFilterItemProvider(this);
		}

		return typeTabFilterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CustomTabFilter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomTabFilterItemProvider customTabFilterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CustomTabFilter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomTabFilterAdapter() {
		if (customTabFilterItemProvider == null) {
			customTabFilterItemProvider = new CustomTabFilterItemProvider(this);
		}

		return customTabFilterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenSharedContributionItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenSharedContributionItemItemProvider genSharedContributionItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenSharedContributionItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenSharedContributionItemAdapter() {
		if (genSharedContributionItemItemProvider == null) {
			genSharedContributionItemItemProvider = new GenSharedContributionItemItemProvider(this);
		}

		return genSharedContributionItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenGroupMarker} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenGroupMarkerItemProvider genGroupMarkerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenGroupMarker}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenGroupMarkerAdapter() {
		if (genGroupMarkerItemProvider == null) {
			genGroupMarkerItemProvider = new GenGroupMarkerItemProvider(this);
		}

		return genGroupMarkerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenSeparator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenSeparatorItemProvider genSeparatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenSeparator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenSeparatorAdapter() {
		if (genSeparatorItemProvider == null) {
			genSeparatorItemProvider = new GenSeparatorItemProvider(this);
		}

		return genSeparatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCustomActionItemProvider genCustomActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCustomActionAdapter() {
		if (genCustomActionItemProvider == null) {
			genCustomActionItemProvider = new GenCustomActionItemProvider(this);
		}

		return genCustomActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommandAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCommandActionItemProvider genCommandActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommandAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCommandActionAdapter() {
		if (genCommandActionItemProvider == null) {
			genCommandActionItemProvider = new GenCommandActionItemProvider(this);
		}

		return genCommandActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoadResourceActionItemProvider loadResourceActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.LoadResourceAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLoadResourceActionAdapter() {
		if (loadResourceActionItemProvider == null) {
			loadResourceActionItemProvider = new LoadResourceActionItemProvider(this);
		}

		return loadResourceActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.InitDiagramAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InitDiagramActionItemProvider initDiagramActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.InitDiagramAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInitDiagramActionAdapter() {
		if (initDiagramActionItemProvider == null) {
			initDiagramActionItemProvider = new InitDiagramActionItemProvider(this);
		}

		return initDiagramActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CreateShortcutActionItemProvider createShortcutActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CreateShortcutAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCreateShortcutActionAdapter() {
		if (createShortcutActionItemProvider == null) {
			createShortcutActionItemProvider = new CreateShortcutActionItemProvider(this);
		}

		return createShortcutActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenActionFactoryContributionItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenActionFactoryContributionItemItemProvider genActionFactoryContributionItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenActionFactoryContributionItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenActionFactoryContributionItemAdapter() {
		if (genActionFactoryContributionItemItemProvider == null) {
			genActionFactoryContributionItemItemProvider = new GenActionFactoryContributionItemItemProvider(this);
		}

		return genActionFactoryContributionItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenMenuManager} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenMenuManagerItemProvider genMenuManagerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenMenuManager}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenMenuManagerAdapter() {
		if (genMenuManagerItemProvider == null) {
			genMenuManagerItemProvider = new GenMenuManagerItemProvider(this);
		}

		return genMenuManagerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenToolBarManager} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenToolBarManagerItemProvider genToolBarManagerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenToolBarManager}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenToolBarManagerAdapter() {
		if (genToolBarManagerItemProvider == null) {
			genToolBarManagerItemProvider = new GenToolBarManagerItemProvider(this);
		}

		return genToolBarManagerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenContextMenu} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenContextMenuItemProvider genContextMenuItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenContextMenu}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenContextMenuAdapter() {
		if (genContextMenuItemProvider == null) {
			genContextMenuItemProvider = new GenContextMenuItemProvider(this);
		}

		return genContextMenuItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenApplicationItemProvider genApplicationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenApplicationAdapter() {
		if (genApplicationItemProvider == null) {
			genApplicationItemProvider = new GenApplicationItemProvider(this);
		}

		return genApplicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenParsersItemProvider genParsersItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenParsersAdapter() {
		if (genParsersItemProvider == null) {
			genParsersItemProvider = new GenParsersItemProvider(this);
		}

		return genParsersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PredefinedParserItemProvider predefinedParserItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPredefinedParserAdapter() {
		if (predefinedParserItemProvider == null) {
			predefinedParserItemProvider = new PredefinedParserItemProvider(this);
		}

		return predefinedParserItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedEnumParser} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PredefinedEnumParserItemProvider predefinedEnumParserItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedEnumParser}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPredefinedEnumParserAdapter() {
		if (predefinedEnumParserItemProvider == null) {
			predefinedEnumParserItemProvider = new PredefinedEnumParserItemProvider(this);
		}

		return predefinedEnumParserItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.OclChoiceParser} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OclChoiceParserItemProvider oclChoiceParserItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.OclChoiceParser}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOclChoiceParserAdapter() {
		if (oclChoiceParserItemProvider == null) {
			oclChoiceParserItemProvider = new OclChoiceParserItemProvider(this);
		}

		return oclChoiceParserItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionLabelParserItemProvider expressionLabelParserItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionLabelParserAdapter() {
		if (expressionLabelParserItemProvider == null) {
			expressionLabelParserItemProvider = new ExpressionLabelParserItemProvider(this);
		}

		return expressionLabelParserItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomParserItemProvider customParserItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomParserAdapter() {
		if (customParserItemProvider == null) {
			customParserItemProvider = new CustomParserItemProvider(this);
		}

		return customParserItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ExternalParser} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalParserItemProvider externalParserItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ExternalParser}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalParserAdapter() {
		if (externalParserItemProvider == null) {
			externalParserItemProvider = new ExternalParserItemProvider(this);
		}

		return externalParserItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenVisualEffect} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenVisualEffectItemProvider genVisualEffectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenVisualEffect}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenVisualEffectAdapter() {
		if (genVisualEffectItemProvider == null) {
			genVisualEffectItemProvider = new GenVisualEffectItemProvider(this);
		}

		return genVisualEffectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomGeneratorExtension} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCustomGeneratorExtensionItemProvider genCustomGeneratorExtensionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomGeneratorExtension}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenCustomGeneratorExtensionAdapter() {
		if (genCustomGeneratorExtensionItemProvider == null) {
			genCustomGeneratorExtensionItemProvider = new GenCustomGeneratorExtensionItemProvider(this);
		}

		return genCustomGeneratorExtensionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenTemplateInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenTemplateInvocationItemProvider genTemplateInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenTemplateInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenTemplateInvocationAdapter() {
		if (genTemplateInvocationItemProvider == null) {
			genTemplateInvocationItemProvider = new GenTemplateInvocationItemProvider(this);
		}

		return genTemplateInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenFixedInputsTemplateInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenFixedInputsTemplateInvocationItemProvider genFixedInputsTemplateInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenFixedInputsTemplateInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenFixedInputsTemplateInvocationAdapter() {
		if (genFixedInputsTemplateInvocationItemProvider == null) {
			genFixedInputsTemplateInvocationItemProvider = new GenFixedInputsTemplateInvocationItemProvider(this);
		}

		return genFixedInputsTemplateInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueExpressionItemProvider valueExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValueExpressionAdapter() {
		if (valueExpressionItemProvider == null) {
			valueExpressionItemProvider = new ValueExpressionItemProvider(this);
		}

		return valueExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenConstraintItemProvider genConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenConstraintAdapter() {
		if (genConstraintItemProvider == null) {
			genConstraintItemProvider = new GenConstraintItemProvider(this);
		}

		return genConstraintItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (genEditorGeneratorItemProvider != null) genEditorGeneratorItemProvider.dispose();
		if (genDiagramItemProvider != null) genDiagramItemProvider.dispose();
		if (genEditorViewItemProvider != null) genEditorViewItemProvider.dispose();
		if (genCustomPreferencePageItemProvider != null) genCustomPreferencePageItemProvider.dispose();
		if (genStandardPreferencePageItemProvider != null) genStandardPreferencePageItemProvider.dispose();
		if (genDiagramPreferencesItemProvider != null) genDiagramPreferencesItemProvider.dispose();
		if (genStandardFontItemProvider != null) genStandardFontItemProvider.dispose();
		if (genCustomFontItemProvider != null) genCustomFontItemProvider.dispose();
		if (genRGBColorItemProvider != null) genRGBColorItemProvider.dispose();
		if (genConstantColorItemProvider != null) genConstantColorItemProvider.dispose();
		if (genPreferenceItemProvider != null) genPreferenceItemProvider.dispose();
		if (genDiagramUpdaterItemProvider != null) genDiagramUpdaterItemProvider.dispose();
		if (genPluginItemProvider != null) genPluginItemProvider.dispose();
		if (dynamicModelAccessItemProvider != null) dynamicModelAccessItemProvider.dispose();
		if (customBehaviourItemProvider != null) customBehaviourItemProvider.dispose();
		if (sharedBehaviourItemProvider != null) sharedBehaviourItemProvider.dispose();
		if (openDiagramBehaviourItemProvider != null) openDiagramBehaviourItemProvider.dispose();
		if (genTopLevelNodeItemProvider != null) genTopLevelNodeItemProvider.dispose();
		if (genChildNodeItemProvider != null) genChildNodeItemProvider.dispose();
		if (genChildSideAffixedNodeItemProvider != null) genChildSideAffixedNodeItemProvider.dispose();
		if (genChildLabelNodeItemProvider != null) genChildLabelNodeItemProvider.dispose();
		if (genCompartmentItemProvider != null) genCompartmentItemProvider.dispose();
		if (genLinkItemProvider != null) genLinkItemProvider.dispose();
		if (genNodeLabelItemProvider != null) genNodeLabelItemProvider.dispose();
		if (genExternalNodeLabelItemProvider != null) genExternalNodeLabelItemProvider.dispose();
		if (genLinkLabelItemProvider != null) genLinkLabelItemProvider.dispose();
		if (metamodelTypeItemProvider != null) metamodelTypeItemProvider.dispose();
		if (specializationTypeItemProvider != null) specializationTypeItemProvider.dispose();
		if (notationTypeItemProvider != null) notationTypeItemProvider.dispose();
		if (labelModelFacetItemProvider != null) labelModelFacetItemProvider.dispose();
		if (typeModelFacetItemProvider != null) typeModelFacetItemProvider.dispose();
		if (typeLinkModelFacetItemProvider != null) typeLinkModelFacetItemProvider.dispose();
		if (featureLinkModelFacetItemProvider != null) featureLinkModelFacetItemProvider.dispose();
		if (featureLabelModelFacetItemProvider != null) featureLabelModelFacetItemProvider.dispose();
		if (designLabelModelFacetItemProvider != null) designLabelModelFacetItemProvider.dispose();
		if (expressionLabelModelFacetItemProvider != null) expressionLabelModelFacetItemProvider.dispose();
		if (colorAttributesItemProvider != null) colorAttributesItemProvider.dispose();
		if (styleAttributesItemProvider != null) styleAttributesItemProvider.dispose();
		if (resizeConstraintsItemProvider != null) resizeConstraintsItemProvider.dispose();
		if (defaultSizeAttributesItemProvider != null) defaultSizeAttributesItemProvider.dispose();
		if (labelOffsetAttributesItemProvider != null) labelOffsetAttributesItemProvider.dispose();
		if (figureViewmapItemProvider != null) figureViewmapItemProvider.dispose();
		if (snippetViewmapItemProvider != null) snippetViewmapItemProvider.dispose();
		if (innerClassViewmapItemProvider != null) innerClassViewmapItemProvider.dispose();
		if (parentAssignedViewmapItemProvider != null) parentAssignedViewmapItemProvider.dispose();
		if (modeledViewmapItemProvider != null) modeledViewmapItemProvider.dispose();
		if (valueExpressionItemProvider != null) valueExpressionItemProvider.dispose();
		if (genConstraintItemProvider != null) genConstraintItemProvider.dispose();
		if (paletteItemProvider != null) paletteItemProvider.dispose();
		if (toolEntryItemProvider != null) toolEntryItemProvider.dispose();
		if (standardEntryItemProvider != null) standardEntryItemProvider.dispose();
		if (separatorItemProvider != null) separatorItemProvider.dispose();
		if (toolGroupItemProvider != null) toolGroupItemProvider.dispose();
		if (genFeatureSeqInitializerItemProvider != null) genFeatureSeqInitializerItemProvider.dispose();
		if (genFeatureValueSpecItemProvider != null) genFeatureValueSpecItemProvider.dispose();
		if (genReferenceNewElementSpecItemProvider != null) genReferenceNewElementSpecItemProvider.dispose();
		if (genLinkConstraintsItemProvider != null) genLinkConstraintsItemProvider.dispose();
		if (genAuditRootItemProvider != null) genAuditRootItemProvider.dispose();
		if (genAuditContainerItemProvider != null) genAuditContainerItemProvider.dispose();
		if (genAuditRuleItemProvider != null) genAuditRuleItemProvider.dispose();
		if (genDomainElementTargetItemProvider != null) genDomainElementTargetItemProvider.dispose();
		if (genDiagramElementTargetItemProvider != null) genDiagramElementTargetItemProvider.dispose();
		if (genDomainAttributeTargetItemProvider != null) genDomainAttributeTargetItemProvider.dispose();
		if (genNotationElementTargetItemProvider != null) genNotationElementTargetItemProvider.dispose();
		if (genMetricContainerItemProvider != null) genMetricContainerItemProvider.dispose();
		if (genMetricRuleItemProvider != null) genMetricRuleItemProvider.dispose();
		if (genAuditedMetricTargetItemProvider != null) genAuditedMetricTargetItemProvider.dispose();
		if (genAuditContextItemProvider != null) genAuditContextItemProvider.dispose();
		if (genExpressionProviderContainerItemProvider != null) genExpressionProviderContainerItemProvider.dispose();
		if (genJavaExpressionProviderItemProvider != null) genJavaExpressionProviderItemProvider.dispose();
		if (genExpressionInterpreterItemProvider != null) genExpressionInterpreterItemProvider.dispose();
		if (genLiteralExpressionProviderItemProvider != null) genLiteralExpressionProviderItemProvider.dispose();
		if (genNavigatorItemProvider != null) genNavigatorItemProvider.dispose();
		if (genNavigatorChildReferenceItemProvider != null) genNavigatorChildReferenceItemProvider.dispose();
		if (genNavigatorPathItemProvider != null) genNavigatorPathItemProvider.dispose();
		if (genNavigatorPathSegmentItemProvider != null) genNavigatorPathSegmentItemProvider.dispose();
		if (genPropertySheetItemProvider != null) genPropertySheetItemProvider.dispose();
		if (genStandardPropertyTabItemProvider != null) genStandardPropertyTabItemProvider.dispose();
		if (genCustomPropertyTabItemProvider != null) genCustomPropertyTabItemProvider.dispose();
		if (typeTabFilterItemProvider != null) typeTabFilterItemProvider.dispose();
		if (customTabFilterItemProvider != null) customTabFilterItemProvider.dispose();
		if (genSharedContributionItemItemProvider != null) genSharedContributionItemItemProvider.dispose();
		if (genGroupMarkerItemProvider != null) genGroupMarkerItemProvider.dispose();
		if (genSeparatorItemProvider != null) genSeparatorItemProvider.dispose();
		if (genCustomActionItemProvider != null) genCustomActionItemProvider.dispose();
		if (genCommandActionItemProvider != null) genCommandActionItemProvider.dispose();
		if (loadResourceActionItemProvider != null) loadResourceActionItemProvider.dispose();
		if (initDiagramActionItemProvider != null) initDiagramActionItemProvider.dispose();
		if (createShortcutActionItemProvider != null) createShortcutActionItemProvider.dispose();
		if (genActionFactoryContributionItemItemProvider != null) genActionFactoryContributionItemItemProvider.dispose();
		if (genMenuManagerItemProvider != null) genMenuManagerItemProvider.dispose();
		if (genToolBarManagerItemProvider != null) genToolBarManagerItemProvider.dispose();
		if (genContextMenuItemProvider != null) genContextMenuItemProvider.dispose();
		if (genApplicationItemProvider != null) genApplicationItemProvider.dispose();
		if (genParsersItemProvider != null) genParsersItemProvider.dispose();
		if (predefinedParserItemProvider != null) predefinedParserItemProvider.dispose();
		if (predefinedEnumParserItemProvider != null) predefinedEnumParserItemProvider.dispose();
		if (oclChoiceParserItemProvider != null) oclChoiceParserItemProvider.dispose();
		if (expressionLabelParserItemProvider != null) expressionLabelParserItemProvider.dispose();
		if (customParserItemProvider != null) customParserItemProvider.dispose();
		if (externalParserItemProvider != null) externalParserItemProvider.dispose();
		if (genVisualEffectItemProvider != null) genVisualEffectItemProvider.dispose();
		if (genCustomGeneratorExtensionItemProvider != null) genCustomGeneratorExtensionItemProvider.dispose();
		if (genTemplateInvocationItemProvider != null) genTemplateInvocationItemProvider.dispose();
		if (genFixedInputsTemplateInvocationItemProvider != null) genFixedInputsTemplateInvocationItemProvider.dispose();
	}

}
