/**
 * Copyright (c) 2013, 2020 Montages AG, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	  Michael Golubev (Montages) - [368169] extract not-generated shared code to GMF-T runtime
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.parsers;

import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Since GMFT 3.1 we don't generate class AbstractParser into every diagram, by extending the
 * org.eclipse.gmf.tooling.runtime.parsers.AbstractAttributeParser.
 * If you want to extend other custom implementation you may change the className and quialifiedClassName DEFINE's
 * which are still used in the extend's clauses for generated PredefinedParser's
 * <p>
 * However, for 3.1 release we still will generate empty file (without any java content),
 * to ensure that the old code, including calls to non existing i18n fields in Messages is cleaned up.
 */
@Singleton
@SuppressWarnings("all")
public class AbstractParser {
  public CharSequence className(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("AbstractAttributeParser");
    return _builder;
  }
  
  public CharSequence packageName(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.tooling.runtime.parsers");
    return _builder;
  }
  
  public String qualifiedClassName(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder.toString();
  }
  
  public CharSequence fullPath(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    String _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence deprecatedQualifiedClassName(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    String _implPackageName = it.getImplPackageName();
    _builder.append(_implPackageName);
    _builder.append(".AbstractParser");
    return _builder;
  }
  
  public CharSequence Main(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("//Since GMFT 3.1 we don\'t generate class AbstractParser into every diagram, instead extend org.eclipse.gmf.tooling.runtime.parsers.AbstractAttributeParser.");
    _builder.newLine();
    return _builder;
  }
}
