/**
 * Copyright (c) 2014, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Svyatoslav Kovalsky (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import xpt.diagram.commands.CreateLinkCommand;
import xpt.diagram.commands.CreateNodeCommand;
import xpt.diagram.editpolicies.CompartmentItemSemanticEditPolicy;
import xpt.diagram.editpolicies.DiagramItemSemanticEditPolicy;
import xpt.diagram.editpolicies.LinkItemSemanticEditPolicy;
import xpt.diagram.editpolicies.NodeItemSemanticEditPolicy;

@Singleton
@SuppressWarnings("all")
public class QualifiedClassNameProvider {
  @Inject
  private CompartmentItemSemanticEditPolicy compItemSemantic;
  
  @Inject
  private DiagramItemSemanticEditPolicy diagramItemSemantic;
  
  @Inject
  private LinkItemSemanticEditPolicy linkItemSemantic;
  
  @Inject
  private NodeItemSemanticEditPolicy nodeItemSemantic;
  
  @Inject
  private CreateLinkCommand linkCommand;
  
  @Inject
  private CreateNodeCommand nodeCommand;
  
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.diagramItemSemantic.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.compItemSemantic.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.linkItemSemantic.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.nodeItemSemantic.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyClassName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.diagramItemSemantic.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.compItemSemantic.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.linkItemSemantic.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  protected CharSequence _getItemSemanticEditPolicyClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.nodeItemSemantic.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  protected CharSequence _getCreateCommandQualifiedClassName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _getCreateCommandQualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.nodeCommand.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getCreateCommandQualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.linkCommand.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence getItemSemanticEditPolicyQualifiedClassName(final GenCommonBase it) {
    if (it instanceof GenCompartment) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenCompartment)it);
    } else if (it instanceof GenNode) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenLink)it);
    } else if (it != null) {
      return _getItemSemanticEditPolicyQualifiedClassName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence getItemSemanticEditPolicyClassName(final GenCommonBase it) {
    if (it instanceof GenCompartment) {
      return _getItemSemanticEditPolicyClassName((GenCompartment)it);
    } else if (it instanceof GenNode) {
      return _getItemSemanticEditPolicyClassName((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _getItemSemanticEditPolicyClassName((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _getItemSemanticEditPolicyClassName((GenLink)it);
    } else if (it != null) {
      return _getItemSemanticEditPolicyClassName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence getCreateCommandQualifiedClassName(final GenCommonBase it) {
    if (it instanceof GenNode) {
      return _getCreateCommandQualifiedClassName((GenNode)it);
    } else if (it instanceof GenLink) {
      return _getCreateCommandQualifiedClassName((GenLink)it);
    } else if (it != null) {
      return _getCreateCommandQualifiedClassName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
