/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #372479, #386838
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ValidationMarker {
  @Inject
  @Extension
  private Common _common;
  
  @MetaDef
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("ValidationMarker");
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence ValidationMarker(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static final String KEY = \"validation_marker\"; //$NON-NLS-1$");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static final ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("[] EMPTY_ARRAY = new ");
    CharSequence _className_2 = this.className(it);
    _builder.append(_className_2, "\t");
    _builder.append("[0];");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final String location;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final String message;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final int statusSeverity;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_3 = this.className(it);
    _builder.append(_className_3, "\t");
    _builder.append("(String location, String message, int statusSeverity) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.location = location;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.message = message;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.statusSeverity = statusSeverity;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String getLocation() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return location;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String getMessage() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return message;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public int getStatusSeverity() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return statusSeverity;\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_9, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static java.util.Map getMarkers(org.eclipse.gef.EditPartViewer viewer) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.Map markers = (java.util.Map) viewer.getProperty(KEY);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (markers == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("markers = new java.util.HashMap();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("viewer.setProperty(KEY, markers);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return markers;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_10, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private static java.util.Set getMarkers(org.eclipse.gef.EditPartViewer viewer, String viewId, boolean create) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.Set markers = (java.util.Set) getMarkers(viewer).get(viewId);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (markers == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (!create) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return java.util.Collections.EMPTY_SET;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("markers = new java.util.HashSet();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("getMarkers(viewer).put(viewId, markers);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return markers;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_11, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static ");
    CharSequence _className_4 = this.className(it);
    _builder.append(_className_4, "\t");
    _builder.append("[] getMarkers(org.eclipse.gef.EditPartViewer viewer, String viewId) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("java.util.Set markers = getMarkers(viewer, viewId, false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (markers.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return EMPTY_ARRAY;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (");
    CharSequence _className_5 = this.className(it);
    _builder.append(_className_5, "\t\t");
    _builder.append("[]) markers.toArray(new ");
    CharSequence _className_6 = this.className(it);
    _builder.append(_className_6, "\t\t");
    _builder.append("[markers.size()]);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_12, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static void removeAllMarkers(org.eclipse.gef.EditPartViewer viewer) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getMarkers(viewer).clear();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_13, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void add(org.eclipse.gef.EditPartViewer viewer, String viewId) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getMarkers(viewer, viewId, true).add(this);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
