/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Michael Golubev (Montages) - initial API and implementation
 *   Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.plugin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.diagram.preferences.extensions;

@Singleton
@SuppressWarnings("all")
public class propUtils {
  @Inject
  @Extension
  private extensions _extensions;
  
  public CharSequence i18n_diagramPreferences(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _i18n = this._extensions.i18n(it);
    _builder.append(_i18n);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
