/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package xpt.providers;

import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
@SuppressWarnings("all")
public class ParserUtils_qvto {
  @MetaDef
  public String parserFieldName(final GenCommonBase element) {
    String _firstLower = StringExtensions.toFirstLower(element.getUniqueIdentifier());
    return (_firstLower + "Parser");
  }
  
  @MetaDef
  public String parserAccessorName(final GenCommonBase element) {
    String _firstUpper = StringExtensions.toFirstUpper(element.getUniqueIdentifier());
    String _plus = ("get" + _firstUpper);
    return (_plus + "Parser");
  }
}
