/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.gmf.internal.xpand.Activator;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.util.ParserException;

public class XpandMarkerManager {
    public static void addMarkers(IFile file, AnalysationIssue ... issues) {
        MarkerData[] data = new MarkerData[issues.length];
        int i = 0;
        AnalysationIssue[] analysationIssueArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysationIssue issue = analysationIssueArray[n2];
            data[i++] = XpandMarkerManager.createMarkerData(issue);
            ++n2;
        }
        XpandMarkerManager.internalAddMarker(file, data);
    }

    public static void addMarkers(IFile file, ParserException.ErrorLocationInfo ... issues) {
        MarkerData[] data = new MarkerData[issues.length];
        int i = 0;
        ParserException.ErrorLocationInfo[] errorLocationInfoArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            ParserException.ErrorLocationInfo iss = errorLocationInfoArray[n2];
            data[i++] = new MarkerData(iss.message, 2, iss.startOffset, iss.endOffset, iss.startLine);
            ++n2;
        }
        XpandMarkerManager.internalAddMarker(file, data);
    }

    public static void addErrorMarker(IFile file, String message, int start, int end) {
        XpandMarkerManager.internalAddMarker(file, new MarkerData(message, 2, start, end));
    }

    private static MarkerData createMarkerData(AnalysationIssue issue) {
        int start = -1;
        int end = -1;
        int line = -1;
        start = issue.getStart();
        end = issue.getEnd();
        line = issue.getLine();
        int severity = issue.isWarningNotError() ? 1 : 2;
        return new MarkerData(issue.getMessage(), severity, start, end, line);
    }

    private static final String getMARKER_TYPE() {
        return String.valueOf(Activator.getId()) + ".xpandProblem";
    }

    private static final void internalAddMarker(final IFile file, final MarkerData ... markerData) {
        try {
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    MarkerData[] markerDataArray = markerData;
                    int n = markerData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MarkerData d = markerDataArray[n2];
                        d.createMarker(file);
                        ++n2;
                    }
                }
            }, file.getWorkspace().getRuleFactory().markerRule((IResource)file), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }

    public static void deleteMarkers(final IResource file) {
        try {
            if (!file.exists()) {
                return;
            }
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    file.deleteMarkers(XpandMarkerManager.getMARKER_TYPE(), true, 2);
                }
            }, file.getWorkspace().getRuleFactory().markerRule(file), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            Activator.log(ce.getStatus());
        }
    }

    private static class MarkerData {
        final String message;
        final int severity;
        final int start;
        final int end;
        final int line;

        MarkerData(String message, int severity, int start, int end) {
            this(message, severity, start, end, -1);
        }

        MarkerData(String message, int severity, int start, int end, int line) {
            this.message = message;
            this.severity = severity;
            this.start = start;
            this.end = end == -1 ? -1 : end + 1;
            this.line = line;
        }

        void createMarker(IFile file) throws CoreException {
            IMarker marker = file.createMarker(XpandMarkerManager.getMARKER_TYPE());
            marker.setAttribute("message", (Object)this.message);
            marker.setAttribute("severity", this.severity);
            marker.setAttribute("location", (Object)this.toLocationString());
            if (this.start != -1 && this.end != -1) {
                marker.setAttribute("charStart", this.start);
                marker.setAttribute("charEnd", this.end);
            }
            if (this.line != -1) {
                marker.setAttribute("lineNumber", this.line);
            }
        }

        private String toLocationString() {
            StringBuilder sb = new StringBuilder();
            if (this.line != -1) {
                sb.append("line: ");
                sb.append(this.line);
            }
            if (this.start != -1 && this.end != -1) {
                boolean theOnlyData;
                boolean bl = theOnlyData = sb.length() == 0;
                if (!theOnlyData) {
                    sb.append(" (");
                }
                sb.append(this.start);
                sb.append(" .. ");
                sb.append(this.end);
                if (!theOnlyData) {
                    sb.append(")");
                }
            }
            return sb.toString();
        }
    }
}

