/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.internal.builder;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.XWTModelBuilder;
import org.osgi.service.component.annotations.Component;

@Component
public class XWTModelBuilderProvider
implements IPapyrusBuilderProvider {
    public static final Set<String> MODEL_FILE_EXTENSIONS = Set.of("xwt", "xmi", "ctx");

    @Override
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.jdt.core.problem";
    }

    @Override
    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        return builderKind == PapyrusBuilderKind.MODEL_RESOURCE && resourceURI.fileExtension() != null && MODEL_FILE_EXTENSIONS.contains(resourceURI.fileExtension());
    }

    @Override
    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        return builderKind == PapyrusBuilderKind.MODEL_RESOURCE ? new XWTModelBuilder() : null;
    }
}

