/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

public class IntegerAndSpreadsheetNumberConverter {
    private IntegerAndSpreadsheetNumberConverter() {
    }

    public static String toString(int number) {
        if (number <= 0) {
            throw new NumberFormatException();
        }
        int tmp = number;
        String string = "";
        while (tmp > 0) {
            int r = (tmp - 1) % 26;
            string = String.valueOf((char)(65 + r)) + string;
            tmp = (tmp - r) / 26;
        }
        return string;
    }

    public static int toInt(String string) {
        if (string == null || string.length() == 0) {
            throw new NumberFormatException();
        }
        string = string.toUpperCase();
        int multiplier = 1;
        int columnNumber = 0;
        int i = string.length() - 1;
        while (i >= 0) {
            char c = string.charAt(i);
            if (c < 'A' || c > 'Z') {
                throw new NumberFormatException();
            }
            int value = (c - 65 + 1) * multiplier;
            columnNumber += value;
            multiplier *= 26;
            --i;
        }
        return columnNumber;
    }
}

