/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests.apireport;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.papyrus.bundles.tests.apireport.SafeDeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Java8DeltaXMLVisitor
extends SafeDeltaXmlVisitor {
    private static final Map<String, Integer> deltaConstantsDecoder = new HashMap<String, Integer>();
    private final Element root = this.getDocument().getDocumentElement();

    static {
        try {
            Field[] fieldArray = IDelta.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field next = fieldArray[n2];
                if (next.getType() == Integer.TYPE) {
                    deltaConstantsDecoder.put(next.getName(), next.getInt(null));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void appendTo(Appendable appendable) throws IOException {
        try {
            appendable.append(this.getXML());
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void processLeafDelta(IDelta delta) {
        super.processLeafDelta(delta);
        Element deltaElement = this.getNewElement();
        if (this.isIncompatible(deltaElement)) {
            this.amend(deltaElement);
        }
    }

    Element getNewElement() {
        NodeList nodes = this.root.getChildNodes();
        return (Element)nodes.item(nodes.getLength() - 1);
    }

    public boolean isIncompatible(Element delta) {
        String result = this.getString(delta, "compatible");
        return !Boolean.parseBoolean(result);
    }

    protected void setCompatible(Element delta, boolean compatible) {
        this.set(delta, "compatible", compatible);
    }

    protected String getString(Element element, String attribute) {
        return element.getAttribute(attribute);
    }

    protected void set(Element element, String attribute, String value) {
        if (value == null) {
            element.removeAttribute(attribute);
        } else {
            element.setAttribute(attribute, value);
        }
    }

    protected boolean getBoolean(Element element, String attribute) {
        String result = this.getString(element, attribute);
        return Boolean.parseBoolean(result);
    }

    protected void set(Element element, String attribute, boolean value) {
        this.set(element, attribute, Boolean.toString(value));
    }

    protected int getInt(Element element, String attribute) {
        String result = this.getString(element, attribute);
        return result == null ? 0 : Integer.parseInt(result);
    }

    protected void set(Element element, String attribute, int value) {
        this.set(element, attribute, Integer.toString(value));
    }

    protected void amend(Element delta) {
        Integer elementType = deltaConstantsDecoder.getOrDefault(this.getString(delta, "element_type"), 0);
        switch (elementType) {
            case 8: {
                this.amendInterface(delta);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void amendInterface(Element delta) {
        boolean compatible = false;
        Integer kind = deltaConstantsDecoder.getOrDefault(this.getString(delta, "kind"), 0);
        String newMessage = null;
        switch (kind) {
            case 1: {
                switch (this.getInt(delta, "flags")) {
                    case 16: {
                        compatible = this.isStatic(delta);
                        if (!compatible || (newMessage = this.getString(delta, "message")) == null) break;
                        newMessage = newMessage.replaceFirst("field", "static field");
                        newMessage = newMessage.replaceFirst("in an interface that .*? has", "has");
                        break;
                    }
                    case 25: {
                        compatible = this.isDefaultOrStaticMethod(delta);
                        if (!compatible || (newMessage = this.getString(delta, "message")) == null) break;
                        newMessage = newMessage.replaceFirst("method", this.isStatic(delta) ? "static method" : "default method");
                        newMessage = newMessage.replaceFirst("in an interface that .*? has", "has");
                    }
                }
                break;
            }
        }
        if (compatible) {
            this.setCompatible(delta, compatible);
            if (newMessage != null) {
                this.set(delta, "message", newMessage);
            }
        }
    }

    private boolean isDefaultOrStaticMethod(Element delta) {
        boolean result = false;
        int modifiers = this.getInt(delta, "newModifiers");
        result = Flags.isDefaultMethod((int)modifiers) || Flags.isStatic((int)modifiers) || !Flags.isAbstract((int)modifiers);
        return result;
    }

    private boolean isStatic(Element delta) {
        boolean result = false;
        int modifiers = this.getInt(delta, "newModifiers");
        result = Flags.isStatic((int)modifiers);
        return result;
    }
}

