/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.widgets.editors.InputDialog;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;
import org.eclipse.papyrus.views.properties.toolsmiths.messages.Messages;
import org.eclipse.papyrus.views.properties.toolsmiths.storage.actions.ContextStorageActionRegistry;
import org.eclipse.papyrus.views.properties.toolsmiths.storage.actions.IContextCopyAction;
import org.eclipse.papyrus.views.properties.toolsmiths.storage.actions.IContextDeleteAction;
import org.eclipse.papyrus.views.properties.toolsmiths.storage.actions.IContextEditAction;
import org.eclipse.papyrus.views.properties.toolsmiths.storage.actions.IContextStorageActionProvider;
import org.eclipse.papyrus.views.properties.toolsmiths.ui.CopyContextAction;
import org.eclipse.papyrus.views.properties.toolsmiths.ui.EditContextAction;
import org.eclipse.papyrus.views.properties.toolsmiths.ui.RemoveContextAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CustomizationDialog
extends TrayDialog
implements SelectionListener {
    private final ContextStorageActionRegistry actionRegistry = new ContextStorageActionRegistry();
    private org.eclipse.swt.widgets.List availableContexts;
    private ListViewer availableContextsViewer;
    private List<Button> copyContextButtons;
    private Button editContext;
    private Button removeContext;

    public CustomizationDialog(Shell shell) {
        super(shell);
    }

    public void create() {
        super.create();
        super.getShell().setText(Messages.CustomizationDialog_customization);
        super.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        Composite contents = new Composite(this.getDialogArea(), 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(contents, 0);
        label.setText(Messages.CustomizationDialog_selectContextToEdit);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Collection contexts = PropertiesRuntime.getConfigurationManager().getCustomizableContexts();
        this.availableContexts = new org.eclipse.swt.widgets.List(contents, 2816);
        this.availableContexts.setLayoutData((Object)new GridData(4, 4, true, true));
        this.availableContextsViewer = new ListViewer(this.availableContexts);
        this.availableContextsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.availableContextsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof Context) {
                    Context context = (Context)element;
                    return String.valueOf(context.getUserLabel()) + (PropertiesRuntime.getConfigurationManager().isPlugin(context) ? Messages.CustomizationDialog_plugin : "");
                }
                return super.getText(element);
            }
        });
        this.availableContextsViewer.setInput((Object)contexts);
        this.availableContexts.addSelectionListener((SelectionListener)this);
        Composite controls = new Composite(contents, 0);
        controls.setLayout((Layout)new FillLayout(512));
        List<IContextStorageActionProvider> providers = this.actionRegistry.getStorageActionProviders();
        this.copyContextButtons = new ArrayList<Button>(providers.size());
        for (IContextStorageActionProvider next : providers) {
            IContextCopyAction copyAction = next.getContextCopyAction();
            if (copyAction == null) continue;
            Button copyContext = new Button(controls, 8);
            copyContext.setText(copyAction.getLabel());
            copyContext.setToolTipText(copyAction.getToolTip());
            copyContext.setData((Object)copyAction);
            copyContext.setEnabled(false);
            copyContext.addSelectionListener((SelectionListener)this);
            this.copyContextButtons.add(copyContext);
        }
        if (this.copyContextButtons.size() == 1) {
            this.copyContextButtons.get(0).setText(Messages.CustomizationDialog_copy);
        }
        this.editContext = new Button(controls, 8);
        this.editContext.setText(Messages.CustomizationDialog_edit);
        this.editContext.setToolTipText(Messages.CustomizationDialog_editSelectedContext);
        this.editContext.setEnabled(false);
        this.editContext.addSelectionListener((SelectionListener)this);
        this.removeContext = new Button(controls, 8);
        this.removeContext.setText(Messages.CustomizationDialog_delete);
        this.removeContext.setToolTipText(Messages.CustomizationDialog_removeSelectedContext);
        this.removeContext.setEnabled(false);
        this.removeContext.addSelectionListener((SelectionListener)this);
        this.availableContextsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean activate = false;
                IContextStorageActionProvider provider = null;
                if (!selection.isEmpty()) {
                    Context context = (Context)selection.getFirstElement();
                    activate = !PropertiesRuntime.getConfigurationManager().isPlugin(context);
                    provider = CustomizationDialog.this.actionRegistry.getStorageActionProvider(context);
                }
                CustomizationDialog.this.editContext.setEnabled(activate);
                IContextEditAction editAction = provider.getContextEditAction();
                CustomizationDialog.this.editContext.setToolTipText(editAction == null ? null : editAction.getToolTip());
                for (Button next : CustomizationDialog.this.copyContextButtons) {
                    next.setEnabled(!selection.isEmpty());
                }
                CustomizationDialog.this.removeContext.setEnabled(activate);
                IContextDeleteAction deleteAction = provider.getContextDeleteAction();
                CustomizationDialog.this.removeContext.setToolTipText(deleteAction == null ? null : deleteAction.getToolTip());
            }
        });
        this.getShell().pack();
    }

    protected void editAction() {
        IStructuredSelection selection = (IStructuredSelection)this.availableContextsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Context) {
            Context sourceContext = (Context)element;
            IContextEditAction editAction = this.actionRegistry.getContextEditAction(sourceContext);
            if (editAction == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.CustomizationDialog_0, (String)Messages.CustomizationDialog_1);
                return;
            }
            try {
                EditContextAction action = new EditContextAction(editAction);
                action.openEditor(sourceContext);
                this.close();
            }
            catch (Exception ex) {
                Activator.log.error("An error occured while initializing the customization editor", (Throwable)ex);
                return;
            }
        }
    }

    protected void copyAction(IContextCopyAction copyAction) {
        IStructuredSelection selection = (IStructuredSelection)this.availableContextsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Context) {
            Context sourceContext = (Context)element;
            CopyContextAction action = new CopyContextAction(copyAction);
            try {
                String targetName;
                Context newContext;
                InputDialog dialog = new InputDialog(this.getShell(), Messages.CustomizationDialog_enterConfigurationName, Messages.CustomizationDialog_enterConfigurationName, String.valueOf(Messages.CustomizationDialog_copyOf) + sourceContext.getName(), new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().equals("")) {
                            return Messages.CustomizationDialog_configurationNameNotEmpty;
                        }
                        if (PropertiesRuntime.getConfigurationManager().getContext(newText) != null) {
                            return Messages.CustomizationDialog_configurationWithSameNameExists;
                        }
                        return null;
                    }
                });
                dialog.setTitle(Messages.CustomizationDialog_configurationName);
                int result = dialog.open();
                if (result == 0 && (newContext = action.copy(sourceContext, targetName = dialog.getText(), false)) != null) {
                    this.availableContextsViewer.setInput((Object)PropertiesRuntime.getConfigurationManager().getContexts());
                    this.availableContextsViewer.setSelection((ISelection)new StructuredSelection((Object)newContext), true);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected void deleteAction() {
        IStructuredSelection selection = (IStructuredSelection)this.availableContextsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Context) {
            Context sourceContext = (Context)element;
            if (PropertiesRuntime.getConfigurationManager().isPlugin(sourceContext)) {
                Activator.log.warn(Messages.CustomizationDialog_cannotDeletePluginContext);
                return;
            }
            IContextDeleteAction deleteAction = this.actionRegistry.getContextDeleteAction(sourceContext);
            if (deleteAction == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.CustomizationDialog_deleteContext, (String)Messages.CustomizationDialog_2);
                return;
            }
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.CustomizationDialog_deleteContext, null, String.valueOf(Messages.CustomizationDialog_deleteContextConfirmation1) + sourceContext.getUserLabel() + Messages.CustomizationDialog_deleteContextConfirmation2, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int result = dialog.open();
            if (result == 0) {
                RemoveContextAction action = new RemoveContextAction(deleteAction);
                action.removeContext(sourceContext);
                this.availableContextsViewer.setInput((Object)PropertiesRuntime.getConfigurationManager().getContexts());
            }
        }
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.editContext) {
            this.editAction();
        } else if (e.widget == this.removeContext) {
            this.deleteAction();
        } else if (e.widget.getData() instanceof IContextCopyAction) {
            this.copyAction((IContextCopyAction)e.widget.getData());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        IStructuredSelection selection;
        if (e.widget == this.availableContexts && !(selection = (IStructuredSelection)this.availableContextsViewer.getSelection()).isEmpty()) {
            Context context = (Context)selection.getFirstElement();
            if (PropertiesRuntime.getConfigurationManager().isPlugin(context)) {
                if (this.copyContextButtons.size() == 1) {
                    this.copyAction((IContextCopyAction)this.copyContextButtons.get(0).getData());
                }
            } else {
                this.editAction();
            }
        }
    }

    public boolean isResizable() {
        return true;
    }
}

