/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesContextPluginChecker;
import org.osgi.service.component.annotations.Component;

@Component
public class PropertiesContextBuilderProvider
implements IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic";
    }

    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        return "ctx".equals(resourceURI.fileExtension()) || this.hasContentType(resourceURI, "org.eclipse.papyrus.infra.properties.context");
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        PluginCheckerBuilder result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic", this::mapContextResources);
        switch (builderKind) {
            case MODEL_RESOURCE: {
                result = result.withChecker(PropertiesContextPluginChecker.modelValidationCheckerFactory()).withChecker(PropertiesContextPluginChecker.customModelCheckerFactory());
                break;
            }
            case BUNDLE_MANIFEST: {
                result = result.withChecker(PropertiesContextPluginChecker.buildPropertiesCheckerFactory()).withChecker(PropertiesContextPluginChecker.modelDependenciesCheckerFactory());
                break;
            }
            case PLUGIN_MANIFEST: {
                result = result.withChecker(PropertiesContextPluginChecker.extensionsCheckerFactory());
            }
        }
        return result;
    }

    private ListMultimap<IFile, Context> mapContextResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"ctx").or(ModelResourceMapper.byContentType((String)"org.eclipse.papyrus.infra.properties.context")), ModelResourceMapper.resourceSets((EPackage.Registry)ResourceUtils.createWorkspaceAwarePackageRegistry()), ModelResourceMapper.rootsOfType(Context.class));
    }
}

